/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.security.service;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.security.detector.AlertType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/lighthouse/security/service/AlertDeactivationService;", "", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "deactivatedAlertTypes", "", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "getDeactivatedAlertsPropertyValue", "", "isAlertTypeDisabled", "", "alertType", "loadDisabledAlertTypes", "safeMappingToAlertType", "sysPropertyAlertId", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertDeactivationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertDeactivationService.kt\ncom/atlassian/lighthouse/security/service/AlertDeactivationService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,50:1\n766#2:51\n857#2,2:52\n1603#2,9:54\n1855#2:63\n1856#2:65\n1612#2:66\n1#3:64\n11#4:67\n10#4,3:68\n*S KotlinDebug\n*F\n+ 1 AlertDeactivationService.kt\ncom/atlassian/lighthouse/security/service/AlertDeactivationService\n*L\n21#1:51\n21#1:52,2\n22#1:54,9\n22#1:63\n22#1:65\n22#1:66\n22#1:64\n41#1:67\n41#1:68,3\n*E\n"})
public final class AlertDeactivationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LighthouseConfig lighthouseConfig;
    @NotNull
    private final Set<AlertType> deactivatedAlertTypes;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final String DISABLE_ALL_ALERTS_VALUE = "all";

    public AlertDeactivationService(@NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.lighthouseConfig = lighthouseConfig;
        this.deactivatedAlertTypes = this.loadDisabledAlertTypes();
    }

    public final boolean isAlertTypeDisabled(@NotNull AlertType alertType) {
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        return this.deactivatedAlertTypes.contains((Object)alertType);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<AlertType> loadDisabledAlertTypes() {
        Set<AlertType> set;
        String propertyValue = this.getDeactivatedAlertsPropertyValue();
        boolean bl = false;
        if (Intrinsics.areEqual(propertyValue, DISABLE_ALL_ALERTS_VALUE)) {
            set = CollectionsKt.toSet((Iterable)AlertType.getEntries());
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            String[] stringArray = new String[]{","};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)propertyValue, stringArray, false, 0, 6, null);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                boolean bl3 = !StringsKt.isBlank(it);
                if (!bl3) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                AlertType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl4 = false;
                String it = (String)element$iv$iv;
                boolean bl5 = false;
                if (this.safeMappingToAlertType(it) == null) continue;
                boolean bl6 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            set = CollectionsKt.toSet((List)destination$iv$iv);
        }
        return set;
    }

    private final AlertType safeMappingToAlertType(String sysPropertyAlertId) {
        AlertType alertType;
        AlertType it = alertType = AlertType.Companion.fromId(((Object)StringsKt.trim((CharSequence)sysPropertyAlertId)).toString());
        boolean bl = false;
        if (it == null) {
            logger.error("[Atlassian Lighthouse] Could not find alert type for property [" + ((Object)StringsKt.trim((CharSequence)sysPropertyAlertId)).toString() + "]");
        }
        return alertType;
    }

    private final String getDeactivatedAlertsPropertyValue() {
        String string = ((Object)StringsKt.trim((CharSequence)this.lighthouseConfig.getDeactivatedAlerts())).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "toLowerCase(...)");
        return string;
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AlertDeactivationService.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/security/service/AlertDeactivationService$Companion;", "", "()V", "DISABLE_ALL_ALERTS_VALUE", "", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

