/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.bitbucket;

import com.atlassian.audit.core.spi.service.CurrentUserProvider;
import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.request.RequestMetadata;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.AuditUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/lighthouse/service/bitbucket/BitbucketCurrentUserProvider;", "Lcom/atlassian/audit/core/spi/service/CurrentUserProvider;", "authenticationContext", "Lcom/atlassian/bitbucket/auth/AuthenticationContext;", "requestManager", "Lcom/atlassian/bitbucket/request/RequestManager;", "(Lcom/atlassian/bitbucket/auth/AuthenticationContext;Lcom/atlassian/bitbucket/request/RequestManager;)V", "currentUser", "Lcom/atlassian/audit/entity/AuditAuthor;", "atlassian-lighthouse-core"})
public final class BitbucketCurrentUserProvider
implements CurrentUserProvider {
    @NotNull
    private final AuthenticationContext authenticationContext;
    @NotNull
    private final RequestManager requestManager;

    public BitbucketCurrentUserProvider(@NotNull AuthenticationContext authenticationContext, @NotNull RequestManager requestManager) {
        Intrinsics.checkNotNullParameter(authenticationContext, "authenticationContext");
        Intrinsics.checkNotNullParameter(requestManager, "requestManager");
        this.authenticationContext = authenticationContext;
        this.requestManager = requestManager;
    }

    @NotNull
    public AuditAuthor currentUser() {
        RequestMetadata requestMetadata = this.requestManager.getRequestMetadata();
        if (requestMetadata == null) {
            AuditAuthor auditAuthor = AuditAuthor.SYSTEM_AUTHOR;
            Intrinsics.checkNotNullExpressionValue(auditAuthor, "SYSTEM_AUTHOR");
            return auditAuthor;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        if (currentUser == null) {
            AuditAuthor auditAuthor = AuditAuthor.ANONYMOUS_AUTHOR;
            Intrinsics.checkNotNullExpressionValue(auditAuthor, "ANONYMOUS_AUTHOR");
            return auditAuthor;
        }
        AuditAuthor auditAuthor = AuditUtils.auditAuthorForUser((ApplicationUser)currentUser);
        Intrinsics.checkNotNullExpressionValue(auditAuthor, "auditAuthorForUser(...)");
        return auditAuthor;
    }
}

