/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.confluence;

import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import com.atlassian.lighthouse.service.confluence.ConfluenceAuditClusterNodeProvider;
import com.atlassian.lighthouse.service.confluence.ConfluenceAuditIpAddressProvider;
import com.atlassian.lighthouse.service.confluence.ConfluenceAuditMethodProvider;
import com.atlassian.lighthouse.service.confluence.ConfluenceAuditUserProvider;
import com.atlassian.lighthouse.service.confluence.ConfluenceBaseUrlProvider;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/lighthouse/service/confluence/ConfluenceThreatEventEntityFactory;", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "auditMethodProvider", "Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditMethodProvider;", "baseUrlProvider", "Lcom/atlassian/lighthouse/service/confluence/ConfluenceBaseUrlProvider;", "clusterNodeProvider", "Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditClusterNodeProvider;", "currentUserProvider", "Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditUserProvider;", "ipAddressProvider", "Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditIpAddressProvider;", "securityUserService", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "(Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditMethodProvider;Lcom/atlassian/lighthouse/service/confluence/ConfluenceBaseUrlProvider;Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditClusterNodeProvider;Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditUserProvider;Lcom/atlassian/lighthouse/service/confluence/ConfluenceAuditIpAddressProvider;Lcom/atlassian/lighthouse/service/user/SecurityUserService;)V", "createThreatEventEntity", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "id", "", "extraAttributes", "", "atlassian-lighthouse-core"})
public final class ConfluenceThreatEventEntityFactory
implements ThreatEventEntityFactory {
    @NotNull
    private final ConfluenceAuditMethodProvider auditMethodProvider;
    @NotNull
    private final ConfluenceBaseUrlProvider baseUrlProvider;
    @NotNull
    private final ConfluenceAuditClusterNodeProvider clusterNodeProvider;
    @NotNull
    private final ConfluenceAuditUserProvider currentUserProvider;
    @NotNull
    private final ConfluenceAuditIpAddressProvider ipAddressProvider;
    @NotNull
    private final SecurityUserService securityUserService;

    public ConfluenceThreatEventEntityFactory(@NotNull ConfluenceAuditMethodProvider auditMethodProvider, @NotNull ConfluenceBaseUrlProvider baseUrlProvider, @NotNull ConfluenceAuditClusterNodeProvider clusterNodeProvider, @NotNull ConfluenceAuditUserProvider currentUserProvider, @NotNull ConfluenceAuditIpAddressProvider ipAddressProvider, @NotNull SecurityUserService securityUserService) {
        Intrinsics.checkNotNullParameter(auditMethodProvider, "auditMethodProvider");
        Intrinsics.checkNotNullParameter(baseUrlProvider, "baseUrlProvider");
        Intrinsics.checkNotNullParameter(clusterNodeProvider, "clusterNodeProvider");
        Intrinsics.checkNotNullParameter(currentUserProvider, "currentUserProvider");
        Intrinsics.checkNotNullParameter(ipAddressProvider, "ipAddressProvider");
        Intrinsics.checkNotNullParameter(securityUserService, "securityUserService");
        this.auditMethodProvider = auditMethodProvider;
        this.baseUrlProvider = baseUrlProvider;
        this.clusterNodeProvider = clusterNodeProvider;
        this.currentUserProvider = currentUserProvider;
        this.ipAddressProvider = ipAddressProvider;
        this.securityUserService = securityUserService;
    }

    @Override
    @NotNull
    public ThreatEventEntity createThreatEventEntity(@NotNull String id, @NotNull Map<String, String> extraAttributes) {
        Intrinsics.checkNotNullParameter(id, "id");
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        String string = this.auditMethodProvider.currentMethod();
        String string2 = this.securityUserService.getUserKeyByAuditAuthor(this.currentUserProvider.currentUser());
        String string3 = this.clusterNodeProvider.currentNodeId();
        String string4 = this.ipAddressProvider.remoteIpAddress();
        String string5 = this.baseUrlProvider.currentBaseUrl();
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue(instant, "now(...)");
        return new ThreatEventEntity(id, string, extraAttributes, string2, string3, string4, string5, instant);
    }
}

