/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.event;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.atlassian.event.AtlassianEventType;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.security.service.AlertService;
import com.atlassian.lighthouse.service.event.EventToThreatsService;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J/\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u0002H\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/service/event/AllowListModificationHandler;", "", "alertService", "Lcom/atlassian/lighthouse/security/service/AlertService;", "eventToThreatsService", "Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "(Lcom/atlassian/lighthouse/security/service/AlertService;Lcom/atlassian/lighthouse/service/event/EventToThreatsService;)V", "handleAllowListEvent", "", "T", "event", "eventType", "Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "(Ljava/lang/Object;Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;Lcom/atlassian/lighthouse/security/detector/AlertType;)V", "isSystemAuthor", "", "threat", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "atlassian-lighthouse-core"})
public final class AllowListModificationHandler {
    @NotNull
    private final AlertService alertService;
    @NotNull
    private final EventToThreatsService eventToThreatsService;

    public AllowListModificationHandler(@NotNull AlertService alertService, @NotNull EventToThreatsService eventToThreatsService) {
        Intrinsics.checkNotNullParameter(alertService, "alertService");
        Intrinsics.checkNotNullParameter(eventToThreatsService, "eventToThreatsService");
        this.alertService = alertService;
        this.eventToThreatsService = eventToThreatsService;
    }

    public final <T> void handleAllowListEvent(T event, @NotNull AtlassianEventType<T> eventType, @NotNull AlertType alertType) {
        Intrinsics.checkNotNullParameter(eventType, "eventType");
        Intrinsics.checkNotNullParameter((Object)alertType, "alertType");
        ThreatEventEntity threat = this.eventToThreatsService.getThreatEntity(event, eventType);
        if (this.isSystemAuthor(threat)) {
            return;
        }
        this.alertService.persistAlertAndSendNotification(alertType, CollectionsKt.listOf(threat));
    }

    private final boolean isSystemAuthor(ThreatEventEntity threat) {
        return Intrinsics.areEqual(threat.getTriggeringUserKey(), AuditAuthor.SYSTEM_AUTHOR.getId());
    }
}

