/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.analytics.AlertStatusChangedAnalyticsEvent;
import com.atlassian.lighthouse.analytics.AnalyticEvent;
import com.atlassian.lighthouse.plugin.PluginInfo;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/service/event/AnalyticsEventPublisher;", "", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/lighthouse/plugin/PluginInfo;)V", "publish", "", "event", "Lcom/atlassian/lighthouse/analytics/AnalyticEvent;", "publishAlertStatusChangedAnalyticEvent", "newStatus", "", "previousStatus", "alertUuid", "", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventPublisher.kt\ncom/atlassian/lighthouse/service/event/AnalyticsEventPublisher\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,33:1\n11#2:34\n10#2,3:35\n*S KotlinDebug\n*F\n+ 1 AnalyticsEventPublisher.kt\ncom/atlassian/lighthouse/service/event/AnalyticsEventPublisher\n*L\n14#1:34\n14#1:35,3\n*E\n"})
public final class AnalyticsEventPublisher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final PluginInfo pluginInfo;
    @NotNull
    private static final Logger logger;

    public AnalyticsEventPublisher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        this.eventPublisher = eventPublisher;
        this.pluginInfo = pluginInfo;
    }

    public final void publishAlertStatusChangedAnalyticEvent(int newStatus, int previousStatus, @NotNull String alertUuid) {
        Intrinsics.checkNotNullParameter(alertUuid, "alertUuid");
        this.publish(new AlertStatusChangedAnalyticsEvent(previousStatus, newStatus, alertUuid, this.pluginInfo));
    }

    private final void publish(AnalyticEvent event) {
        try {
            this.eventPublisher.publish((Object)event);
        }
        catch (Exception e) {
            logger.error("error occurred trying to publish analytics event", (Throwable)e);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        AnalyticsEventPublisher.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/event/AnalyticsEventPublisher$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

