/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.event;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.analytics.statistics.AlertStatisticsFailedAnalyticEvent;
import com.atlassian.lighthouse.analytics.statistics.AlertStatisticsSuccessAnalyticEvent;
import com.atlassian.lighthouse.analytics.statistics.AlertStatisticsTriggeredAnalyticEvent;
import com.atlassian.lighthouse.analytics.statistics.GuardDetectAlertStatisticsAnalyticEvent;
import com.atlassian.lighthouse.dto.GuardDetectAlertStatistics;
import com.atlassian.lighthouse.plugin.PluginInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ&\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/service/event/DailyAnalyticsEventPublisher;", "", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/lighthouse/plugin/PluginInfo;)V", "publishGuardDetectSuccessAnalyticEvent", "", "guardDetectAlertStatistics", "Lcom/atlassian/lighthouse/dto/GuardDetectAlertStatistics;", "scheduledAt", "", "startFrom", "publishScheduleFailedAnalyticEvent", "publishScheduleSuccessAnalyticEvent", "eventName", "", "alertCount", "publishScheduleTriggeredAnalyticEvent", "atlassian-lighthouse-core"})
public final class DailyAnalyticsEventPublisher {
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final PluginInfo pluginInfo;

    public DailyAnalyticsEventPublisher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        this.eventPublisher = eventPublisher;
        this.pluginInfo = pluginInfo;
    }

    public final void publishScheduleFailedAnalyticEvent(long scheduledAt, long startFrom) {
        this.eventPublisher.publish((Object)new AlertStatisticsFailedAnalyticEvent(scheduledAt, startFrom, this.pluginInfo));
    }

    public final void publishScheduleSuccessAnalyticEvent(@NotNull String eventName, long alertCount, long scheduledAt, long startFrom) {
        Intrinsics.checkNotNullParameter(eventName, "eventName");
        this.eventPublisher.publish((Object)new AlertStatisticsSuccessAnalyticEvent(eventName, alertCount, scheduledAt, startFrom, this.pluginInfo));
    }

    public final void publishScheduleTriggeredAnalyticEvent(long scheduledAt, long startFrom) {
        this.eventPublisher.publish((Object)new AlertStatisticsTriggeredAnalyticEvent(scheduledAt, startFrom, this.pluginInfo));
    }

    public final void publishGuardDetectSuccessAnalyticEvent(@NotNull GuardDetectAlertStatistics guardDetectAlertStatistics, long scheduledAt, long startFrom) {
        Intrinsics.checkNotNullParameter(guardDetectAlertStatistics, "guardDetectAlertStatistics");
        this.eventPublisher.publish((Object)new GuardDetectAlertStatisticsAnalyticEvent(guardDetectAlertStatistics.getTotalSuccessfulAlerts(), guardDetectAlertStatistics.getTotalFailedAlerts(), guardDetectAlertStatistics.getTotalFailedMaxRetryAlerts(), guardDetectAlertStatistics.getMaximumRetryCount(), scheduledAt, startFrom, this.pluginInfo));
    }
}

