/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.event;

import com.atlassian.lighthouse.config.alerts.ChangedValueSettings;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.matchers.atlassian.event.AtlassianEventType;
import com.atlassian.lighthouse.service.ThreatEventEntityFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eJ'\u0010\u0010\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0011\u001a\u0002H\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/service/event/EventToThreatsService;", "", "threatEventEntityFactory", "Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;", "(Lcom/atlassian/lighthouse/service/ThreatEventEntityFactory;)V", "getThreatEntitiesUsingChangedValues", "", "Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "T", "atlassianEventType", "Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;", "changedValueSettings", "Lcom/atlassian/lighthouse/config/alerts/ChangedValueSettings;", "extraAttributes", "", "", "getThreatEntity", "event", "(Ljava/lang/Object;Lcom/atlassian/lighthouse/matchers/atlassian/event/AtlassianEventType;)Lcom/atlassian/lighthouse/database/entities/ThreatEventEntity;", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nEventToThreatsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventToThreatsService.kt\ncom/atlassian/lighthouse/service/event/EventToThreatsService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1603#2,9:44\n1855#2:53\n1856#2:55\n1612#2:56\n1#3:54\n*S KotlinDebug\n*F\n+ 1 EventToThreatsService.kt\ncom/atlassian/lighthouse/service/event/EventToThreatsService\n*L\n26#1:44,9\n26#1:53\n26#1:55\n26#1:56\n26#1:54\n*E\n"})
public final class EventToThreatsService {
    @NotNull
    private final ThreatEventEntityFactory threatEventEntityFactory;

    public EventToThreatsService(@NotNull ThreatEventEntityFactory threatEventEntityFactory) {
        Intrinsics.checkNotNullParameter(threatEventEntityFactory, "threatEventEntityFactory");
        this.threatEventEntityFactory = threatEventEntityFactory;
    }

    @NotNull
    public final <T> ThreatEventEntity getThreatEntity(T event, @NotNull AtlassianEventType<T> atlassianEventType) {
        Intrinsics.checkNotNullParameter(atlassianEventType, "atlassianEventType");
        return this.threatEventEntityFactory.createThreatEventEntity(atlassianEventType.getAlertId(), atlassianEventType.getMapEventToExtraAttributes().invoke(event));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<ThreatEventEntity> getThreatEntitiesUsingChangedValues(@NotNull AtlassianEventType<T> atlassianEventType, @NotNull List<? extends ChangedValueSettings> changedValueSettings, @NotNull Map<String, String> extraAttributes) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter(atlassianEventType, "atlassianEventType");
        Intrinsics.checkNotNullParameter(changedValueSettings, "changedValueSettings");
        Intrinsics.checkNotNullParameter(extraAttributes, "extraAttributes");
        Iterable iterable = changedValueSettings;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ThreatEventEntity threatEventEntity;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ChangedValueSettings setting = (ChangedValueSettings)((Object)element$iv$iv);
            boolean bl2 = false;
            String fromValue = extraAttributes.get(setting.getFrom());
            String toValue = extraAttributes.get(setting.getTo());
            if (fromValue != null && toValue != null && !Intrinsics.areEqual(fromValue, toValue)) {
                Pair[] pairArray = new Pair[]{TuplesKt.to(setting.getFrom(), fromValue), TuplesKt.to(setting.getTo(), toValue)};
                threatEventEntity = this.threatEventEntityFactory.createThreatEventEntity(atlassianEventType.getAlertId(), MapsKt.mapOf(pairArray));
            } else {
                threatEventEntity = null;
            }
            if (threatEventEntity == null) continue;
            ThreatEventEntity it$iv$iv = threatEventEntity;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }
}

