/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.feature.flagging;

import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagService;
import com.atlassian.lighthouse.service.feature.flagging.LighthouseFeatureFlag;
import com.atlassian.sal.api.features.DarkFeatureManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/lighthouse/service/feature/flagging/DefaultFeatureFlagService;", "Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;", "darkFeatureManager", "Lcom/atlassian/sal/api/features/DarkFeatureManager;", "(Lcom/atlassian/sal/api/features/DarkFeatureManager;)V", "disableFeature", "", "featureFlag", "Lcom/atlassian/lighthouse/service/feature/flagging/LighthouseFeatureFlag;", "enableFeature", "isFeatureEnabled", "", "atlassian-lighthouse-core"})
public final class DefaultFeatureFlagService
implements FeatureFlagService {
    @NotNull
    private final DarkFeatureManager darkFeatureManager;

    public DefaultFeatureFlagService(@NotNull DarkFeatureManager darkFeatureManager) {
        Intrinsics.checkNotNullParameter(darkFeatureManager, "darkFeatureManager");
        this.darkFeatureManager = darkFeatureManager;
    }

    @Override
    public void enableFeature(@NotNull LighthouseFeatureFlag featureFlag) {
        Intrinsics.checkNotNullParameter(featureFlag, "featureFlag");
        if (featureFlag.getOnByDefault()) {
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.disabledFeatureKey());
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.enabledFeatureKey());
        } else {
            this.darkFeatureManager.enableFeatureForAllUsers(featureFlag.enabledFeatureKey());
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.disabledFeatureKey());
        }
    }

    @Override
    public void disableFeature(@NotNull LighthouseFeatureFlag featureFlag) {
        Intrinsics.checkNotNullParameter(featureFlag, "featureFlag");
        if (!featureFlag.getOnByDefault()) {
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.disabledFeatureKey());
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.enabledFeatureKey());
        } else {
            this.darkFeatureManager.enableFeatureForAllUsers(featureFlag.disabledFeatureKey());
            this.darkFeatureManager.disableFeatureForAllUsers(featureFlag.enabledFeatureKey());
        }
    }

    @Override
    public boolean isFeatureEnabled(@NotNull LighthouseFeatureFlag featureFlag) {
        Intrinsics.checkNotNullParameter(featureFlag, "featureFlag");
        boolean onByDefault = featureFlag.getOnByDefault();
        Boolean bl = this.darkFeatureManager.isEnabledForAllUsers(featureFlag.enabledFeatureKey()).orElse(false);
        Intrinsics.checkNotNullExpressionValue(bl, "orElse(...)");
        if (bl.booleanValue()) {
            return true;
        }
        Boolean bl2 = this.darkFeatureManager.isEnabledForAllUsers(featureFlag.disabledFeatureKey()).orElse(false);
        Intrinsics.checkNotNullExpressionValue(bl2, "orElse(...)");
        if (bl2.booleanValue()) {
            return false;
        }
        return onByDefault;
    }
}

