/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.group.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.lighthouse.service.AbstractCachedService;
import com.atlassian.lighthouse.service.group.cache.AdminGroupCache;
import com.atlassian.lighthouse.service.group.supplier.AdminGroupNamesFinder;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u000f\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0010\u0010\u0010\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "Lcom/atlassian/lighthouse/service/AbstractCachedService;", "Lcom/atlassian/lighthouse/service/group/cache/AdminGroupCache;", "adminGroupNamesFinder", "Lcom/atlassian/lighthouse/service/group/supplier/AdminGroupNamesFinder;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "cacheRebuildSeconds", "", "(Lcom/atlassian/lighthouse/service/group/supplier/AdminGroupNamesFinder;Lcom/atlassian/cache/CacheManager;J)V", "fetchValues", "isGroupNameInAdminCache", "", "groupName", "", "isGroupNameInSysAdminCache", "isGroupNameInSysAdminOrAdminCache", "rebuildAdminGroupCacheIfExists", "", "atlassian-lighthouse-core"})
public final class CachedAdminGroupService
extends AbstractCachedService<AdminGroupCache> {
    @NotNull
    private final AdminGroupNamesFinder adminGroupNamesFinder;

    public CachedAdminGroupService(@NotNull AdminGroupNamesFinder adminGroupNamesFinder, @NotNull CacheManager cacheManager, long cacheRebuildSeconds) {
        Intrinsics.checkNotNullParameter(adminGroupNamesFinder, "adminGroupNamesFinder");
        Intrinsics.checkNotNullParameter(cacheManager, "cacheManager");
        super(cacheManager, "Security alerts - admin group names cache", cacheRebuildSeconds);
        this.adminGroupNamesFinder = adminGroupNamesFinder;
    }

    public final boolean isGroupNameInAdminCache(@Nullable String groupName) {
        return groupName != null && ((AdminGroupCache)this.getCachedReference().get()).getAdmins().contains(groupName);
    }

    public final boolean isGroupNameInSysAdminCache(@Nullable String groupName) {
        return groupName != null && ((AdminGroupCache)this.getCachedReference().get()).getSysadmins().contains(groupName);
    }

    public final boolean isGroupNameInSysAdminOrAdminCache(@Nullable String groupName) {
        return this.isGroupNameInSysAdminCache(groupName) || this.isGroupNameInAdminCache(groupName);
    }

    public final void rebuildAdminGroupCacheIfExists(@NotNull String groupName) {
        Intrinsics.checkNotNullParameter(groupName, "groupName");
        Object object = this.getCachedReference().get();
        Intrinsics.checkNotNullExpressionValue(object, "get(...)");
        AdminGroupCache adminGroupCache = (AdminGroupCache)object;
        if (adminGroupCache.getAdmins().contains(groupName) || adminGroupCache.getSysadmins().contains(groupName)) {
            this.rebuildCache();
        }
    }

    @Override
    @NotNull
    public AdminGroupCache fetchValues() {
        AdminGroupCache adminGroupCache;
        try {
            adminGroupCache = new AdminGroupCache(this.adminGroupNamesFinder.getAdminGroupNames(), this.adminGroupNamesFinder.getSysAdminGroupNames());
        }
        catch (Exception exception) {
            AbstractCachedService.Companion.getLogger().error("[Atlassian Lighthouse] Admin group names failed to retrieve. Resorting to an empty set.", (Throwable)exception);
            adminGroupCache = new AdminGroupCache(SetsKt.emptySet(), SetsKt.emptySet());
        }
        return adminGroupCache;
    }
}

