/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.GuardPushStatus;
import com.atlassian.lighthouse.service.guard.ApiResponse;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.CreateAlerts;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.CreateAlertsResponse;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.Data;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.Node;
import com.atlassian.lighthouse.service.guard.graphql.response.createalerts.Shepherd;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J>\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nJ2\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J@\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00162\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/lighthouse/service/guard/CreateAlertsResponseMapper;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "determineFailureStatus", "Lcom/atlassian/lighthouse/database/entities/GuardPushStatus;", "unpushedAlertsRetryJobIntervalInMillis", "", "guardRetryCount", "", "maxRetryLifespanInMillis", "isCreateAlertsMutationSucceeded", "", "response", "Lcom/atlassian/lighthouse/service/guard/ApiResponse$Success;", "Lcom/atlassian/lighthouse/service/guard/graphql/response/createalerts/CreateAlertsResponse;", "mapAlertsToGuardPushStatuses", "", "alerts", "", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "Lcom/atlassian/lighthouse/service/guard/ApiResponse;", "mapFailedAlerts", "mapSucceededAndFailedAlerts", "parseSucceededAlertIds", "", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nCreateAlertsResponseMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CreateAlertsResponseMapper.kt\ncom/atlassian/lighthouse/service/guard/CreateAlertsResponseMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,89:1\n1179#2,2:90\n1253#2,4:92\n1179#2,2:96\n1253#2,4:98\n1549#2:102\n1620#2,3:103\n11#3:106\n10#3,3:107\n*S KotlinDebug\n*F\n+ 1 CreateAlertsResponseMapper.kt\ncom/atlassian/lighthouse/service/guard/CreateAlertsResponseMapper\n*L\n37#1:90,2\n37#1:92,4\n52#1:96,2\n52#1:98,4\n58#1:102\n58#1:103,3\n87#1:106\n87#1:107,3\n*E\n"})
public final class CreateAlertsResponseMapper {
    @NotNull
    public static final CreateAlertsResponseMapper INSTANCE = new CreateAlertsResponseMapper();
    @NotNull
    private static final Logger logger;

    private CreateAlertsResponseMapper() {
    }

    @NotNull
    public final Map<Long, GuardPushStatus> mapAlertsToGuardPushStatuses(@NotNull List<AlertEntity> alerts, @NotNull ApiResponse<CreateAlertsResponse> response, long unpushedAlertsRetryJobIntervalInMillis, long maxRetryLifespanInMillis) {
        Map<Long, GuardPushStatus> map;
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        Intrinsics.checkNotNullParameter(response, "response");
        ApiResponse<CreateAlertsResponse> apiResponse = response;
        if (apiResponse instanceof ApiResponse.Success) {
            map = this.isCreateAlertsMutationSucceeded((ApiResponse.Success)response) ? this.mapSucceededAndFailedAlerts((ApiResponse.Success)response, alerts, unpushedAlertsRetryJobIntervalInMillis, maxRetryLifespanInMillis) : this.mapFailedAlerts(alerts, unpushedAlertsRetryJobIntervalInMillis, maxRetryLifespanInMillis);
        } else if (apiResponse instanceof ApiResponse.Failure) {
            map = this.mapFailedAlerts(alerts, unpushedAlertsRetryJobIntervalInMillis, maxRetryLifespanInMillis);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, GuardPushStatus> mapSucceededAndFailedAlerts(ApiResponse.Success<CreateAlertsResponse> response, List<AlertEntity> alerts, long unpushedAlertsRetryJobIntervalInMillis, long maxRetryLifespanInMillis) {
        void $this$associateTo$iv$iv;
        List<String> pushedAlertUuids = this.parseSucceededAlertIds(response);
        Iterable $this$associate$iv = alerts;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AlertEntity it = (AlertEntity)element$iv$iv;
            boolean bl = false;
            Long l = it.getId();
            Intrinsics.checkNotNull(l);
            Pair<Long, GuardPushStatus> pair = TuplesKt.to(l, pushedAlertUuids.contains(it.getUuid()) ? GuardPushStatus.PUSHED : INSTANCE.determineFailureStatus(unpushedAlertsRetryJobIntervalInMillis, it.getGuardRetryCount(), maxRetryLifespanInMillis));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Long, GuardPushStatus> mapFailedAlerts(List<AlertEntity> alerts, long unpushedAlertsRetryJobIntervalInMillis, long maxRetryLifespanInMillis) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = alerts;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            AlertEntity it = (AlertEntity)element$iv$iv;
            boolean bl = false;
            Long l = it.getId();
            Intrinsics.checkNotNull(l);
            Pair<Long, GuardPushStatus> pair = TuplesKt.to(l, INSTANCE.determineFailureStatus(unpushedAlertsRetryJobIntervalInMillis, it.getGuardRetryCount(), maxRetryLifespanInMillis));
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseSucceededAlertIds(ApiResponse.Success<CreateAlertsResponse> response) {
        List list;
        Object object = response.getValue();
        if (object != null && (object = ((CreateAlertsResponse)object).getData()) != null && (object = ((Data)object).getShepherd()) != null && (object = ((Shepherd)object).getCreateAlerts()) != null && (object = ((CreateAlerts)object).getNodes()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getCustomFields().getAlertId());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final boolean isCreateAlertsMutationSucceeded(ApiResponse.Success<CreateAlertsResponse> response) {
        CreateAlerts createAlerts;
        Shepherd shepherd;
        Data data;
        CreateAlertsResponse createAlertsResponse = response.getValue();
        return createAlertsResponse != null && (data = createAlertsResponse.getData()) != null && (shepherd = data.getShepherd()) != null && (createAlerts = shepherd.getCreateAlerts()) != null ? createAlerts.getSuccess() : false;
    }

    private final GuardPushStatus determineFailureStatus(long unpushedAlertsRetryJobIntervalInMillis, int guardRetryCount, long maxRetryLifespanInMillis) {
        boolean hasReachedMaxRetryTimespan = (long)guardRetryCount * unpushedAlertsRetryJobIntervalInMillis > maxRetryLifespanInMillis;
        return hasReachedMaxRetryTimespan ? GuardPushStatus.FAILED_MAX_RETRIES : GuardPushStatus.FAILED;
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        CreateAlertsResponseMapper.logger = logger;
    }
}

