/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard;

import com.atlassian.lighthouse.database.entities.AlertEntity;
import com.atlassian.lighthouse.database.entities.ThreatEventEntity;
import com.atlassian.lighthouse.security.detector.AlertType;
import com.atlassian.lighthouse.service.guard.GuardAlertStatusMapper;
import com.atlassian.lighthouse.service.guard.PersonallyIdentifiableInformationFilter;
import com.atlassian.lighthouse.service.guard.graphql.request.AttributeData;
import com.atlassian.lighthouse.service.guard.graphql.request.BatchAlertsVariablesData;
import com.atlassian.lighthouse.service.guard.graphql.request.CreateAlertPayload;
import com.atlassian.lighthouse.service.guard.graphql.request.CreateAlertsPayload;
import com.atlassian.lighthouse.service.guard.graphql.request.CustomFieldsData;
import com.atlassian.lighthouse.service.guard.graphql.request.InputData;
import com.atlassian.lighthouse.service.guard.graphql.request.TimeData;
import com.atlassian.lighthouse.service.guard.graphql.request.VariablesData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J,\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/lighthouse/service/guard/GuardDetectPayloadMapper;", "", "()V", "getAttributes", "", "Lcom/atlassian/lighthouse/service/guard/graphql/request/AttributeData;", "alert", "Lcom/atlassian/lighthouse/database/entities/AlertEntity;", "getBatchCreateAlertPayload", "Lcom/atlassian/lighthouse/service/guard/graphql/request/CreateAlertsPayload;", "alerts", "workspaceAri", "", "productId", "query", "getCreateAlertPayload", "Lcom/atlassian/lighthouse/service/guard/graphql/request/CreateAlertPayload;", "getInputData", "Lcom/atlassian/lighthouse/service/guard/graphql/request/InputData;", "getPayloadType", "alertType", "Lcom/atlassian/lighthouse/security/detector/AlertType;", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nGuardDetectPayloadMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuardDetectPayloadMapper.kt\ncom/atlassian/lighthouse/service/guard/GuardDetectPayloadMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1549#2:109\n1620#2,3:110\n1360#2:113\n1446#2,5:114\n766#2:119\n857#2,2:120\n1603#2,9:122\n1855#2:131\n1856#2:134\n1612#2:135\n1#3:132\n1#3:133\n*S KotlinDebug\n*F\n+ 1 GuardDetectPayloadMapper.kt\ncom/atlassian/lighthouse/service/guard/GuardDetectPayloadMapper\n*L\n41#1:109\n41#1:110,3\n89#1:113\n89#1:114,5\n90#1:119\n90#1:120,2\n91#1:122,9\n91#1:131\n91#1:134\n91#1:135\n91#1:133\n*E\n"})
public final class GuardDetectPayloadMapper {
    @NotNull
    public static final GuardDetectPayloadMapper INSTANCE = new GuardDetectPayloadMapper();

    private GuardDetectPayloadMapper() {
    }

    @NotNull
    public final CreateAlertPayload getCreateAlertPayload(@NotNull AlertEntity alert, @NotNull String workspaceAri, @NotNull String productId, @NotNull String query) {
        Intrinsics.checkNotNullParameter(alert, "alert");
        Intrinsics.checkNotNullParameter(workspaceAri, "workspaceAri");
        Intrinsics.checkNotNullParameter(productId, "productId");
        Intrinsics.checkNotNullParameter(query, "query");
        InputData inputData = this.getInputData(alert, workspaceAri, productId);
        CreateAlertPayload payload = new CreateAlertPayload(query, new VariablesData(inputData));
        return payload;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CreateAlertsPayload getBatchCreateAlertPayload(@NotNull List<AlertEntity> alerts, @NotNull String workspaceAri, @NotNull String productId, @NotNull String query) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(alerts, "alerts");
        Intrinsics.checkNotNullParameter(workspaceAri, "workspaceAri");
        Intrinsics.checkNotNullParameter(productId, "productId");
        Intrinsics.checkNotNullParameter(query, "query");
        Iterable $this$map$iv = alerts;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AlertEntity alertEntity = (AlertEntity)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(INSTANCE.getInputData((AlertEntity)it, workspaceAri, productId));
        }
        List inputDataList = (List)destination$iv$iv;
        CreateAlertsPayload payload = new CreateAlertsPayload(query, new BatchAlertsVariablesData(inputDataList));
        return payload;
    }

    private final InputData getInputData(AlertEntity alert, String workspaceAri, String productId) {
        String title = alert.getAlertType().toString();
        String type = this.getPayloadType(alert.getAlertType(), productId);
        List<AttributeData> attributesData = this.getAttributes(alert);
        ThreatEventEntity threatEventEntity = CollectionsKt.firstOrNull(alert.getThreatEvents());
        String guardAlertStatus = GuardAlertStatusMapper.INSTANCE.mapLighthouseAlertStatusToGuardAlertStatus(alert.getAlertStatus()).toString();
        ThreatEventEntity threatEventEntity2 = threatEventEntity;
        ThreatEventEntity threatEventEntity3 = threatEventEntity;
        ThreatEventEntity threatEventEntity4 = threatEventEntity;
        ThreatEventEntity threatEventEntity5 = threatEventEntity;
        CustomFieldsData customFieldsData = new CustomFieldsData(alert.getUuid(), threatEventEntity2 != null ? threatEventEntity2.getNodeId() : null, threatEventEntity3 != null ? threatEventEntity3.getEventSource() : null, threatEventEntity4 != null ? threatEventEntity4.getSourceIp() : null, threatEventEntity5 != null ? threatEventEntity5.getInstanceBaseUrl() : null, attributesData);
        String string = alert.getTimestamp().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        InputData inputData = new InputData(customFieldsData, workspaceAri, new TimeData(string), title, type, guardAlertStatus);
        return inputData;
    }

    /*
     * WARNING - void declaration
     */
    private final List<AttributeData> getAttributes(AlertEntity alert) {
        List<AttributeData> list;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = alert.getThreatEvents();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (ThreatEventEntity)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = ((ThreatEventEntity)it).getExtraAttributes().entrySet();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(!PersonallyIdentifiableInformationFilter.INSTANCE.getAttributesNotToSendToGuardDetect().contains(it.getKey()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            AttributeData attributeData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value != null) {
                String it2;
                boolean bl3 = false;
                attributeData = new AttributeData(key, it2);
            } else {
                attributeData = null;
            }
            if (attributeData == null) continue;
            AttributeData it$iv$iv = attributeData;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List<AttributeData> it3 = list = CollectionsKt.toList((List)destination$iv$iv);
        boolean bl = false;
        return !((Collection)it3).isEmpty() ? list : null;
    }

    private final String getPayloadType(AlertType alertType, String productId) {
        String string;
        if (StringsKt.contains((CharSequence)productId, "conf", true)) {
            string = "confluence";
        } else if (StringsKt.contains((CharSequence)productId, "jira", true)) {
            string = "jira";
        } else {
            throw new IllegalArgumentException("Unsupported product type: " + productId);
        }
        String productType = string;
        return "data-center-" + productType + "-" + alertType.getId() + "-alert";
    }
}

