/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.guard;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.security.service.Constants;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagRegistry;
import com.atlassian.lighthouse.service.feature.flagging.FeatureFlagService;
import com.atlassian.lighthouse.service.guard.ApiResponse;
import com.atlassian.lighthouse.service.guard.GuardDetectService;
import com.atlassian.lighthouse.service.guard.cache.TimeBasedSingleValueCache;
import com.atlassian.lighthouse.service.guard.dto.GuardRejectionReason;
import com.atlassian.lighthouse.service.guard.dto.GuardStatus;
import com.atlassian.lighthouse.service.guard.graphql.response.workspace.Data;
import com.atlassian.lighthouse.service.guard.graphql.response.workspace.Shepherd;
import com.atlassian.lighthouse.service.guard.graphql.response.workspace.WorkspaceByOrgId;
import com.atlassian.lighthouse.service.guard.graphql.response.workspace.WorkspaceResponse;
import com.atlassian.plugins.cloud.connect.companion.client.CloudLink;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceLocator;
import com.atlassian.plugins.cloud.connect.companion.client.DataSharingLevel;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J\u0016\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0002J\u0006\u0010\u0018\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\u0011R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "", "cloudRequestServiceLocator", "Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestServiceLocator;", "featureFlagService", "Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;", "guardDetectService", "Lcom/atlassian/lighthouse/service/guard/GuardDetectService;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/plugins/cloud/connect/companion/client/CloudRequestServiceLocator;Lcom/atlassian/lighthouse/service/feature/flagging/FeatureFlagService;Lcom/atlassian/lighthouse/service/guard/GuardDetectService;Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "cacheExpiryInMilliseconds", "", "guardStatusLocalCache", "Lcom/atlassian/lighthouse/service/guard/cache/TimeBasedSingleValueCache;", "Lcom/atlassian/lighthouse/service/guard/dto/GuardStatus;", "canSendAlerts", "", "connectionHasMinimumDataSharingLevel", "constructGuardStatusWithWorkspaceResponse", "response", "Lcom/atlassian/lighthouse/service/guard/ApiResponse;", "Lcom/atlassian/lighthouse/service/guard/graphql/response/workspace/WorkspaceResponse;", "getGuardStatusFromCloud", "getGuardStatusFromLocalCache", "isConnectedWithCloudOrg", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nGuardIntegrationMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GuardIntegrationMonitor.kt\ncom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,126:1\n30#2:127\n1#3:128\n11#4:129\n10#4,3:130\n*S KotlinDebug\n*F\n+ 1 GuardIntegrationMonitor.kt\ncom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor\n*L\n117#1:127\n123#1:129\n123#1:130,3\n*E\n"})
public final class GuardIntegrationMonitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CloudRequestServiceLocator cloudRequestServiceLocator;
    @NotNull
    private final FeatureFlagService featureFlagService;
    @NotNull
    private final GuardDetectService guardDetectService;
    private final long cacheExpiryInMilliseconds;
    @NotNull
    private final TimeBasedSingleValueCache<GuardStatus> guardStatusLocalCache;
    @NotNull
    private static final Logger logger;

    public GuardIntegrationMonitor(@NotNull CloudRequestServiceLocator cloudRequestServiceLocator, @NotNull FeatureFlagService featureFlagService, @NotNull GuardDetectService guardDetectService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(cloudRequestServiceLocator, "cloudRequestServiceLocator");
        Intrinsics.checkNotNullParameter(featureFlagService, "featureFlagService");
        Intrinsics.checkNotNullParameter(guardDetectService, "guardDetectService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.cloudRequestServiceLocator = cloudRequestServiceLocator;
        this.featureFlagService = featureFlagService;
        this.guardDetectService = guardDetectService;
        this.cacheExpiryInMilliseconds = lighthouseConfig.getGuardStatusLocalCacheExpiryInSeconds() * (long)1000;
        this.guardStatusLocalCache = new TimeBasedSingleValueCache((Function0)new Function0<GuardStatus>(this){
            final /* synthetic */ GuardIntegrationMonitor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GuardStatus invoke() {
                return GuardIntegrationMonitor.access$getGuardStatusFromCloud(this.this$0);
            }
        }, this.cacheExpiryInMilliseconds);
    }

    public final boolean canSendAlerts() {
        return this.featureFlagService.isFeatureEnabled(FeatureFlagRegistry.INSTANCE.getGUARD_DETECT_INTEGRATION()) && this.getGuardStatusFromLocalCache().getAcceptingAlerts();
    }

    @NotNull
    public final GuardStatus getGuardStatusFromLocalCache() {
        return !this.isConnectedWithCloudOrg() ? new GuardStatus(false, SetsKt.setOf(GuardRejectionReason.NO_CLOUD_LINK), Instant.now().toEpochMilli(), null) : (!this.connectionHasMinimumDataSharingLevel() ? new GuardStatus(false, SetsKt.setOf(GuardRejectionReason.MINIMUM_DATA_SHARING_LEVEL_NOT_MET), Instant.now().toEpochMilli(), null) : this.guardStatusLocalCache.get());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isConnectedWithCloudOrg() {
        try {
            if (!this.cloudRequestServiceLocator.isPresent()) return false;
            CloudLink cloudLink = this.cloudRequestServiceLocator.getCloudLink().orElse(null);
            if (cloudLink == null) return false;
            String string = cloudLink.getOrgId();
            if (string == null) return false;
            return true;
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Failed to retrieve cloud link information", (Throwable)e);
            return false;
        }
    }

    private final GuardStatus getGuardStatusFromCloud() {
        ApiResponse<WorkspaceResponse> response = this.guardDetectService.getGuardStatus();
        return this.constructGuardStatusWithWorkspaceResponse(response);
    }

    private final GuardStatus constructGuardStatusWithWorkspaceResponse(ApiResponse<WorkspaceResponse> response) {
        long timestamp = Instant.now().toEpochMilli();
        ApiResponse<WorkspaceResponse> apiResponse = response;
        if (apiResponse instanceof ApiResponse.Success) {
            WorkspaceByOrgId workspaceByOrgId;
            Shepherd shepherd;
            Object object;
            WorkspaceResponse data = (WorkspaceResponse)((ApiResponse.Success)response).getValue();
            String workspaceAri = data != null && (object = data.getData()) != null && (shepherd = ((Data)object).getShepherd()) != null && (workspaceByOrgId = shepherd.getWorkspaceByOrgId()) != null ? workspaceByOrgId.getAri() : null;
            object = workspaceAri;
            if (!(object == null || object.length() == 0)) {
                return new GuardStatus(true, SetsKt.emptySet(), timestamp, workspaceAri);
            }
            return new GuardStatus(false, SetsKt.setOf(GuardRejectionReason.INVALID_WORKSPACE), timestamp, null);
        }
        if (apiResponse instanceof ApiResponse.Failure) {
            logger.error("[Atlassian Lighthouse] Failed to get Guard Status with error code " + ((ApiResponse.Failure)response).getErrorCode() + " and exception: " + ((ApiResponse.Failure)response).getErrorBody());
            Integer n = ((ApiResponse.Failure)response).getErrorCode();
            int n2 = 403;
            if (n != null && n == n2) {
                return new GuardStatus(false, SetsKt.setOf(GuardRejectionReason.INVALID_WORKSPACE), timestamp, null);
            }
            return new GuardStatus(false, SetsKt.setOf(GuardRejectionReason.UNKNOWN), timestamp, null);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean connectionHasMinimumDataSharingLevel() {
        boolean bl;
        DataSharingLevel dataSharingLevel;
        CloudLink cloudLink;
        Optional<CloudLink> optional = this.cloudRequestServiceLocator.getCloudLink();
        Intrinsics.checkNotNullExpressionValue(optional, "getCloudLink(...)");
        Optional<CloudLink> $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            cloudLink = $this$getOrElse$iv.get();
        } else {
            boolean bl2 = false;
            cloudLink = null;
        }
        CloudLink cloudLink2 = cloudLink;
        if (cloudLink2 != null && (dataSharingLevel = cloudLink2.getDataSharingLevel()) != null) {
            DataSharingLevel it = dataSharingLevel;
            boolean bl3 = false;
            bl = it.compareTo((Enum)Constants.INSTANCE.getMinLighthouseDataSharingLevel()) >= 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ GuardStatus access$getGuardStatusFromCloud(GuardIntegrationMonitor $this) {
        return $this.getGuardStatusFromCloud();
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        GuardIntegrationMonitor.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

