/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.scheduler;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.database.dao.ScheduleJobManager;
import com.atlassian.lighthouse.service.statistics.AlertStatisticsService;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.caesium.cron.parser.CronExpressionParser;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.cron.CronSyntaxException;
import com.atlassian.scheduler.status.JobDetails;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner;", "Lcom/atlassian/scheduler/JobRunner;", "alertStatisticsService", "Lcom/atlassian/lighthouse/service/statistics/AlertStatisticsService;", "scheduleJobManager", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/lighthouse/service/statistics/AlertStatisticsService;Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "runJob", "Lcom/atlassian/scheduler/JobRunnerResponse;", "request", "Lcom/atlassian/scheduler/JobRunnerRequest;", "scheduleJob", "", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nDailyAnalyticsScheduleJobRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DailyAnalyticsScheduleJobRunner.kt\ncom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,74:1\n11#2:75\n10#2,3:76\n*S KotlinDebug\n*F\n+ 1 DailyAnalyticsScheduleJobRunner.kt\ncom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner\n*L\n71#1:75\n71#1:76,3\n*E\n"})
public final class DailyAnalyticsScheduleJobRunner
implements JobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AlertStatisticsService alertStatisticsService;
    @NotNull
    private final ScheduleJobManager scheduleJobManager;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final LighthouseConfig lighthouseConfig;
    @NotNull
    private static final JobRunnerKey KEY;
    @NotNull
    private static final Logger logger;

    public DailyAnalyticsScheduleJobRunner(@NotNull AlertStatisticsService alertStatisticsService, @NotNull ScheduleJobManager scheduleJobManager, @NotNull SchedulerService schedulerService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(alertStatisticsService, "alertStatisticsService");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        Intrinsics.checkNotNullParameter(schedulerService, "schedulerService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.alertStatisticsService = alertStatisticsService;
        this.scheduleJobManager = scheduleJobManager;
        this.schedulerService = schedulerService;
        this.lighthouseConfig = lighthouseConfig;
    }

    @Nullable
    public JobRunnerResponse runJob(@NotNull JobRunnerRequest request) {
        Intrinsics.checkNotNullParameter(request, "request");
        long scheduledAtEpoch = Instant.now().toEpochMilli();
        String string = KEY.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        Long l = this.scheduleJobManager.getLastTimeJobRunSuccessfully(string);
        long startFromEpoch = l != null ? l : 0L;
        try {
            this.alertStatisticsService.getAndPublishAlertStatistics(scheduledAtEpoch, startFromEpoch);
            String string2 = KEY.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
            this.scheduleJobManager.updateLastTimeJobRunSuccessfully(string2, scheduledAtEpoch);
            return JobRunnerResponse.success((String)"Lighthouse statistics sent successfully");
        }
        catch (Exception e) {
            return JobRunnerResponse.failed((String)("Failed to send Lighthouse statistics: " + e.getMessage()));
        }
    }

    public final void scheduleJob() throws SchedulerServiceException {
        for (JobDetails jobDetails : this.schedulerService.getJobsByJobRunnerKey(KEY)) {
            logger.debug("[Atlassian Lighthouse] Un-scheduling job: " + jobDetails.getJobId());
            this.schedulerService.unscheduleJob(jobDetails.getJobId());
        }
        String runSchedule = this.lighthouseConfig.getAnalyticsJobRunSchedule();
        logger.debug("[Atlassian Lighthouse] Try applying cron settings: " + runSchedule);
        try {
            CronExpressionParser.parse((String)runSchedule);
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)KEY).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forCronExpression((String)runSchedule));
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            String string = KEY.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.scheduleJobManager.createScheduleJob(string, null);
        }
        catch (CronSyntaxException e) {
            logger.error("[Atlassian Lighthouse] Failed to start Lighthouse DailyAnalyticsScheduleJobRunner - Invalid cron settings: " + runSchedule);
            throw e;
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Failed to start Lighthouse DailyAnalyticsScheduleJobRunner", (Throwable)e);
            throw e;
        }
    }

    static {
        JobRunnerKey jobRunnerKey = JobRunnerKey.of((String)DailyAnalyticsScheduleJobRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(jobRunnerKey, "of(...)");
        KEY = jobRunnerKey;
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        DailyAnalyticsScheduleJobRunner.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner$Companion;", "", "()V", "KEY", "Lcom/atlassian/scheduler/config/JobRunnerKey;", "getKEY", "()Lcom/atlassian/scheduler/config/JobRunnerKey;", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JobRunnerKey getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

