/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.scheduler;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.plugin.PluginInfo;
import com.atlassian.lighthouse.service.scheduler.DailyAnalyticsScheduleJobRunner;
import com.atlassian.lighthouse.service.scheduler.UnpushedGuardAlertsRetryJobScheduler;
import com.atlassian.plugin.event.events.PluginDisablingEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0019H\u0007R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/LighthouseScheduleLauncher;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "pluginInfo", "Lcom/atlassian/lighthouse/plugin/PluginInfo;", "scheduleService", "Lcom/atlassian/scheduler/SchedulerService;", "dailyAnalyticsScheduleJobRunner", "Lcom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner;", "unpushedGuardAlertsRetryJobScheduler", "Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler;", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/lighthouse/plugin/PluginInfo;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/lighthouse/service/scheduler/DailyAnalyticsScheduleJobRunner;Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler;)V", "lighthousePluginKey", "", "afterPropertiesSet", "", "destroy", "onAppShutdown", "onAppStart", "pluginShutdown", "event", "Lcom/atlassian/plugin/event/events/PluginDisablingEvent;", "pluginStartup", "Lcom/atlassian/plugin/event/events/PluginEnabledEvent;", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nLighthouseScheduleLauncher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LighthouseScheduleLauncher.kt\ncom/atlassian/lighthouse/service/scheduler/LighthouseScheduleLauncher\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,68:1\n11#2:69\n10#2,3:70\n*S KotlinDebug\n*F\n+ 1 LighthouseScheduleLauncher.kt\ncom/atlassian/lighthouse/service/scheduler/LighthouseScheduleLauncher\n*L\n65#1:69\n65#1:70,3\n*E\n"})
public class LighthouseScheduleLauncher
implements InitializingBean,
DisposableBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final SchedulerService scheduleService;
    @NotNull
    private final DailyAnalyticsScheduleJobRunner dailyAnalyticsScheduleJobRunner;
    @NotNull
    private final UnpushedGuardAlertsRetryJobScheduler unpushedGuardAlertsRetryJobScheduler;
    @NotNull
    private final String lighthousePluginKey;
    @NotNull
    private static final Logger logger;

    public LighthouseScheduleLauncher(@NotNull EventPublisher eventPublisher, @NotNull PluginInfo pluginInfo, @NotNull SchedulerService scheduleService, @NotNull DailyAnalyticsScheduleJobRunner dailyAnalyticsScheduleJobRunner, @NotNull UnpushedGuardAlertsRetryJobScheduler unpushedGuardAlertsRetryJobScheduler) {
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        Intrinsics.checkNotNullParameter(pluginInfo, "pluginInfo");
        Intrinsics.checkNotNullParameter(scheduleService, "scheduleService");
        Intrinsics.checkNotNullParameter(dailyAnalyticsScheduleJobRunner, "dailyAnalyticsScheduleJobRunner");
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryJobScheduler, "unpushedGuardAlertsRetryJobScheduler");
        this.eventPublisher = eventPublisher;
        this.scheduleService = scheduleService;
        this.dailyAnalyticsScheduleJobRunner = dailyAnalyticsScheduleJobRunner;
        this.unpushedGuardAlertsRetryJobScheduler = unpushedGuardAlertsRetryJobScheduler;
        this.lighthousePluginKey = pluginInfo.getBundleName();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public final void pluginStartup(@NotNull PluginEnabledEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(event.getPlugin().getKey(), this.lighthousePluginKey)) {
            this.onAppStart();
        }
    }

    @EventListener
    public final void pluginShutdown(@NotNull PluginDisablingEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        if (Intrinsics.areEqual(event.getPlugin().getKey(), this.lighthousePluginKey)) {
            this.onAppShutdown();
        }
    }

    private final void onAppStart() {
        try {
            this.scheduleService.registerJobRunner(DailyAnalyticsScheduleJobRunner.Companion.getKEY(), (JobRunner)this.dailyAnalyticsScheduleJobRunner);
            this.dailyAnalyticsScheduleJobRunner.scheduleJob();
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Failed to start DailyAnalyticsScheduleJobRunner", (Throwable)e);
        }
        this.unpushedGuardAlertsRetryJobScheduler.registerAndStartJobRunner();
    }

    private final void onAppShutdown() {
        try {
            this.scheduleService.unregisterJobRunner(DailyAnalyticsScheduleJobRunner.Companion.getKEY());
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Unable to unregister job runners DailyAnalyticsScheduleJobRunner", (Throwable)e);
        }
        this.unpushedGuardAlertsRetryJobScheduler.unregisterJobRunner();
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        LighthouseScheduleLauncher.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/LighthouseScheduleLauncher$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

