/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.scheduler;

import com.atlassian.lighthouse.config.system.LighthouseConfig;
import com.atlassian.lighthouse.database.dao.ScheduleJobManager;
import com.atlassian.lighthouse.service.scheduler.UnpushedGuardAlertsRetryJobRunner;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.status.JobDetails;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler;", "", "unpushedGuardAlertsRetryJobRunner", "Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner;", "scheduleJobManager", "Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;", "schedulerService", "Lcom/atlassian/scheduler/SchedulerService;", "lighthouseConfig", "Lcom/atlassian/lighthouse/config/system/LighthouseConfig;", "(Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobRunner;Lcom/atlassian/lighthouse/database/dao/ScheduleJobManager;Lcom/atlassian/scheduler/SchedulerService;Lcom/atlassian/lighthouse/config/system/LighthouseConfig;)V", "registerAndStartJobRunner", "", "scheduleJob", "unregisterJobRunner", "Companion", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nUnpushedGuardAlertsRetryJobScheduler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnpushedGuardAlertsRetryJobScheduler.kt\ncom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler\n+ 2 Logger.kt\ncom/atlassian/lighthouse/util/LoggerKt\n*L\n1#1,73:1\n11#2:74\n10#2,3:75\n*S KotlinDebug\n*F\n+ 1 UnpushedGuardAlertsRetryJobScheduler.kt\ncom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler\n*L\n70#1:74\n70#1:75,3\n*E\n"})
public final class UnpushedGuardAlertsRetryJobScheduler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UnpushedGuardAlertsRetryJobRunner unpushedGuardAlertsRetryJobRunner;
    @NotNull
    private final ScheduleJobManager scheduleJobManager;
    @NotNull
    private final SchedulerService schedulerService;
    @NotNull
    private final LighthouseConfig lighthouseConfig;
    @NotNull
    private static final Logger logger;

    public UnpushedGuardAlertsRetryJobScheduler(@NotNull UnpushedGuardAlertsRetryJobRunner unpushedGuardAlertsRetryJobRunner, @NotNull ScheduleJobManager scheduleJobManager, @NotNull SchedulerService schedulerService, @NotNull LighthouseConfig lighthouseConfig) {
        Intrinsics.checkNotNullParameter(unpushedGuardAlertsRetryJobRunner, "unpushedGuardAlertsRetryJobRunner");
        Intrinsics.checkNotNullParameter(scheduleJobManager, "scheduleJobManager");
        Intrinsics.checkNotNullParameter(schedulerService, "schedulerService");
        Intrinsics.checkNotNullParameter(lighthouseConfig, "lighthouseConfig");
        this.unpushedGuardAlertsRetryJobRunner = unpushedGuardAlertsRetryJobRunner;
        this.scheduleJobManager = scheduleJobManager;
        this.schedulerService = schedulerService;
        this.lighthouseConfig = lighthouseConfig;
    }

    public final void scheduleJob() throws SchedulerServiceException {
        JobRunnerKey jobRunnerKey = this.unpushedGuardAlertsRetryJobRunner.getJobRunnerKey();
        for (JobDetails jobDetails : this.schedulerService.getJobsByJobRunnerKey(jobRunnerKey)) {
            logger.debug("[Atlassian Lighthouse] Un-scheduling job: " + jobDetails.getJobId());
            this.schedulerService.unscheduleJob(jobDetails.getJobId());
        }
        long runInterval = this.lighthouseConfig.getUnpushedCloudAlertsJobRunIntervalInMinutes() * (long)60 * 1000L;
        logger.debug("[Atlassian Lighthouse] Try applying interval: " + runInterval);
        try {
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER).withSchedule(Schedule.forInterval((long)runInterval, (Date)Date.from(Instant.now())));
            this.schedulerService.scheduleJobWithGeneratedId(jobConfig);
            String string = jobRunnerKey.toString();
            Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
            this.scheduleJobManager.createScheduleJob(string, null);
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Failed to start UnpushedGuardAlertsRetryScheduleJobRunner", (Throwable)e);
            throw e;
        }
    }

    public final void registerAndStartJobRunner() {
        try {
            this.schedulerService.registerJobRunner(this.unpushedGuardAlertsRetryJobRunner.getJobRunnerKey(), (JobRunner)this.unpushedGuardAlertsRetryJobRunner);
            this.scheduleJob();
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Unable to register job runners UnpushedGuardAlertsRetryJobRunner", (Throwable)e);
        }
    }

    public final void unregisterJobRunner() {
        try {
            this.schedulerService.unregisterJobRunner(this.unpushedGuardAlertsRetryJobRunner.getJobRunnerKey());
        }
        catch (Exception e) {
            logger.error("[Atlassian Lighthouse] Unable to unregister job runners UnpushedGuardAlertsRetryJobRunner", (Throwable)e);
        }
    }

    static {
        boolean $i$f$getLogger = false;
        Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        UnpushedGuardAlertsRetryJobScheduler.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/atlassian/lighthouse/service/scheduler/UnpushedGuardAlertsRetryJobScheduler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "atlassian-lighthouse-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

