/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.statistics;

import com.atlassian.lighthouse.database.dao.AlertStatisticsManager;
import com.atlassian.lighthouse.database.query.AlertsQuery;
import com.atlassian.lighthouse.dto.AlertStatusStatistics;
import com.atlassian.lighthouse.dto.AlertTypeStatistics;
import com.atlassian.lighthouse.dto.GuardDetectAlertStatistics;
import com.atlassian.lighthouse.security.detector.AlertStatus;
import com.atlassian.lighthouse.service.event.DailyAnalyticsEventPublisher;
import com.atlassian.lighthouse.service.guard.GuardIntegrationMonitor;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/service/statistics/AlertStatisticsService;", "", "alertStatisticsManager", "Lcom/atlassian/lighthouse/database/dao/AlertStatisticsManager;", "dailyAnalyticsEventPublisher", "Lcom/atlassian/lighthouse/service/event/DailyAnalyticsEventPublisher;", "guardIntegrationMonitor", "Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;", "(Lcom/atlassian/lighthouse/database/dao/AlertStatisticsManager;Lcom/atlassian/lighthouse/service/event/DailyAnalyticsEventPublisher;Lcom/atlassian/lighthouse/service/guard/GuardIntegrationMonitor;)V", "getAndPublishAlertStatistics", "", "scheduledAtEpoch", "", "startFromEpoch", "sendGuardDetectStatistics", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nAlertStatisticsService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlertStatisticsService.kt\ncom/atlassian/lighthouse/service/statistics/AlertStatisticsService\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,77:1\n215#2,2:78\n215#2,2:80\n*S KotlinDebug\n*F\n+ 1 AlertStatisticsService.kt\ncom/atlassian/lighthouse/service/statistics/AlertStatisticsService\n*L\n30#1:78,2\n41#1:80,2\n*E\n"})
public final class AlertStatisticsService {
    @NotNull
    private final AlertStatisticsManager alertStatisticsManager;
    @NotNull
    private final DailyAnalyticsEventPublisher dailyAnalyticsEventPublisher;
    @NotNull
    private final GuardIntegrationMonitor guardIntegrationMonitor;

    public AlertStatisticsService(@NotNull AlertStatisticsManager alertStatisticsManager, @NotNull DailyAnalyticsEventPublisher dailyAnalyticsEventPublisher, @NotNull GuardIntegrationMonitor guardIntegrationMonitor) {
        Intrinsics.checkNotNullParameter(alertStatisticsManager, "alertStatisticsManager");
        Intrinsics.checkNotNullParameter(dailyAnalyticsEventPublisher, "dailyAnalyticsEventPublisher");
        Intrinsics.checkNotNullParameter(guardIntegrationMonitor, "guardIntegrationMonitor");
        this.alertStatisticsManager = alertStatisticsManager;
        this.dailyAnalyticsEventPublisher = dailyAnalyticsEventPublisher;
        this.guardIntegrationMonitor = guardIntegrationMonitor;
    }

    public final void getAndPublishAlertStatistics(long scheduledAtEpoch, long startFromEpoch) {
        this.dailyAnalyticsEventPublisher.publishScheduleTriggeredAnalyticEvent(scheduledAtEpoch, startFromEpoch);
        try {
            AlertTypeStatistics alertTypeStatistics = this.alertStatisticsManager.getAlertTypeStatistics(new AlertsQuery(null, Instant.ofEpochMilli(startFromEpoch), null, null, null, null, null, null, 253, null));
            this.dailyAnalyticsEventPublisher.publishScheduleSuccessAnalyticEvent("daily-total", alertTypeStatistics.getTotalAlerts(), scheduledAtEpoch, startFromEpoch);
            Map<String, Long> $this$forEach$iv = alertTypeStatistics.getAlertCountByType();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, Long>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, Long> element$iv;
                Map.Entry<String, Long> entry = element$iv = iterator2.next();
                boolean bl = false;
                String alertType = entry.getKey();
                long count = ((Number)entry.getValue()).longValue();
                this.dailyAnalyticsEventPublisher.publishScheduleSuccessAnalyticEvent(alertType, count, scheduledAtEpoch, startFromEpoch);
            }
            AlertStatusStatistics alertStatusStatistics = this.alertStatisticsManager.getAlertStatusStatistics(new AlertsQuery(null, null, null, null, null, null, null, null, 255, null));
            this.dailyAnalyticsEventPublisher.publishScheduleSuccessAnalyticEvent("total", alertStatusStatistics.getTotalAlerts(), scheduledAtEpoch, 0L);
            Map<AlertStatus, Long> $this$forEach$iv2 = alertStatusStatistics.getAlertCountByStatus();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<AlertStatus, Long>> iterator3 = $this$forEach$iv2.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<AlertStatus, Long> element$iv;
                Map.Entry<AlertStatus, Long> entry = element$iv = iterator3.next();
                boolean bl = false;
                AlertStatus alertStatus = entry.getKey();
                long count = ((Number)entry.getValue()).longValue();
                this.dailyAnalyticsEventPublisher.publishScheduleSuccessAnalyticEvent("AlertStatus." + alertStatus.name(), count, scheduledAtEpoch, 0L);
            }
            if (this.guardIntegrationMonitor.isConnectedWithCloudOrg()) {
                this.sendGuardDetectStatistics(startFromEpoch, scheduledAtEpoch);
            }
        }
        catch (Exception e) {
            this.dailyAnalyticsEventPublisher.publishScheduleFailedAnalyticEvent(scheduledAtEpoch, startFromEpoch);
            throw e;
        }
    }

    private final void sendGuardDetectStatistics(long startFromEpoch, long scheduledAtEpoch) {
        GuardDetectAlertStatistics guardDetectAlertStatistics = this.alertStatisticsManager.getGuardDetectAlertStatistics(new AlertsQuery(null, Instant.ofEpochMilli(startFromEpoch), null, null, null, null, null, null, 253, null));
        this.dailyAnalyticsEventPublisher.publishGuardDetectSuccessAnalyticEvent(guardDetectAlertStatistics, scheduledAtEpoch, startFromEpoch);
    }
}

