/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\fH\u0016\u00a2\u0006\u0002\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/lighthouse/service/user/BitbucketSecurityUserService;", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "permissionService", "Lcom/atlassian/bitbucket/permission/PermissionService;", "securityGroupName", "", "userService", "Lcom/atlassian/bitbucket/user/UserService;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/bitbucket/permission/PermissionService;Ljava/lang/String;Lcom/atlassian/bitbucket/user/UserService;Lcom/atlassian/sal/api/user/UserManager;)V", "getSysAdminEmailAddresses", "", "()[Ljava/lang/String;", "getUserKeyByAuditAuthor", "auditAuthor", "Lcom/atlassian/audit/entity/AuditAuthor;", "getUserKeyByUserName", "userName", "getValidSecurityGroupUserEmails", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nBitbucketSecurityUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitbucketSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/BitbucketSecurityUserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,44:1\n1603#2,9:45\n1855#2:54\n1856#2:56\n1612#2:57\n766#2:60\n857#2,2:61\n1603#2,9:63\n1855#2:72\n1856#2:74\n1612#2:75\n1#3:55\n1#3:73\n37#4,2:58\n37#4,2:76\n*S KotlinDebug\n*F\n+ 1 BitbucketSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/BitbucketSecurityUserService\n*L\n23#1:45,9\n23#1:54\n23#1:56\n23#1:57\n32#1:60\n32#1:61,2\n33#1:63,9\n33#1:72\n33#1:74\n33#1:75\n23#1:55\n33#1:73\n25#1:58,2\n35#1:76,2\n*E\n"})
public final class BitbucketSecurityUserService
implements SecurityUserService {
    @NotNull
    private final PermissionService permissionService;
    @NotNull
    private final String securityGroupName;
    @NotNull
    private final UserService userService;
    @NotNull
    private final UserManager userManager;

    public BitbucketSecurityUserService(@NotNull PermissionService permissionService, @NotNull String securityGroupName, @NotNull UserService userService, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(permissionService, "permissionService");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        Intrinsics.checkNotNullParameter(userService, "userService");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.permissionService = permissionService;
        this.securityGroupName = securityGroupName;
        this.userService = userService;
        this.userManager = userManager;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getSysAdminEmailAddresses() {
        void $this$mapNotNullTo$iv$iv;
        Set set = this.userService.getUsersByName(this.permissionService.getUsersWithPermission(Permission.SYS_ADMIN), false);
        Intrinsics.checkNotNullExpressionValue(set, "getUsersByName(...)");
        Iterable $this$mapNotNull$iv = set;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl2 = false;
            if (it.getEmailAddress() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String[] getValidSecurityGroupUserEmails() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable iterable = this.userService.findUsersByGroup(this.securityGroupName, (PageRequest)new PageRequestImpl(0, 100)).getValues();
        Intrinsics.checkNotNullExpressionValue(iterable, "getValues(...)");
        Iterable $this$filter$iv = iterable;
        boolean $i$f$filter = false;
        Iterable iterable2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl = false;
            if (!this.permissionService.hasGlobalPermission(it, Permission.LICENSED_USER)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl2 = false;
            if (it.getEmailAddress() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    @Override
    @NotNull
    public String getUserKeyByAuditAuthor(@NotNull AuditAuthor auditAuthor) {
        Intrinsics.checkNotNullParameter(auditAuthor, "auditAuthor");
        String string = auditAuthor.getId();
        Intrinsics.checkNotNullExpressionValue(string, "getId(...)");
        return string;
    }

    @Override
    @Nullable
    public String getUserKeyByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        UserProfile userProfile = this.userManager.getUserProfile(userName);
        return userProfile != null && (userProfile = userProfile.getUserKey()) != null ? userProfile.getStringValue() : null;
    }

    @Override
    public boolean isSecurityGroupSetup() {
        return SecurityUserService.DefaultImpls.isSecurityGroupSetup(this);
    }
}

