/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.lighthouse.service.user.Constants;
import com.atlassian.lighthouse.service.user.UserDetails;
import com.atlassian.lighthouse.service.user.UserDetailsFinder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/lighthouse/service/user/DefaultUserDetailsFinder;", "Lcom/atlassian/lighthouse/service/user/UserDetailsFinder;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "i18nResolver", "Lcom/atlassian/sal/api/message/I18nResolver;", "(Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/sal/api/message/I18nResolver;)V", "fromUserKey", "Lcom/atlassian/lighthouse/service/user/UserDetails;", "userKey", "", "fromUsername", "username", "atlassian-lighthouse-core"})
public final class DefaultUserDetailsFinder
implements UserDetailsFinder {
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final I18nResolver i18nResolver;

    public DefaultUserDetailsFinder(@NotNull UserManager userManager, @NotNull I18nResolver i18nResolver) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(i18nResolver, "i18nResolver");
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    @NotNull
    public UserDetails fromUserKey(@Nullable String userKey) {
        String string;
        String string2 = string = userKey;
        if (string2 == null ? true : Intrinsics.areEqual(string2, Constants.INSTANCE.getUNKNOWN_USER_KEY())) {
            return UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core();
        }
        if (Intrinsics.areEqual(string, Constants.INSTANCE.getSYSTEM_USER_KEY())) {
            return UserDetailsFinder.Companion.getSYSTEM_USER_DETAILS$atlassian_lighthouse_core();
        }
        if (Intrinsics.areEqual(string, Constants.INSTANCE.getANONYMOUS_USER_KEY())) {
            return UserDetailsFinder.Companion.getANONYMOUS_USER_DETAILS$atlassian_lighthouse_core();
        }
        UserProfile userProfile = this.userManager.getUserProfile(new UserKey(userKey));
        if (userProfile == null || userProfile.getUsername() == null) {
            return UserDetailsFinder.Companion.createUnknownUserWithKey(userKey, this.i18nResolver);
        }
        String string3 = userProfile.getEmail();
        String string4 = userProfile.getFullName();
        String string5 = userProfile.getUsername();
        Intrinsics.checkNotNullExpressionValue(string5, "getUsername(...)");
        return new UserDetails(string3, string4, userKey, string5, this.userManager.isAdmin(userProfile.getUserKey()), this.userManager.isSystemAdmin(userProfile.getUserKey()));
    }

    @Override
    @NotNull
    public UserDetails fromUsername(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        UserProfile userProfile = this.userManager.getUserProfile(username);
        if (userProfile == null || userProfile.getUsername() == null) {
            return UserDetailsFinder.Companion.getUNKNOWN_USER_DETAILS$atlassian_lighthouse_core();
        }
        String string = userProfile.getEmail();
        String string2 = userProfile.getFullName();
        String string3 = userProfile.getUserKey().toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        String string4 = userProfile.getUsername();
        Intrinsics.checkNotNullExpressionValue(string4, "getUsername(...)");
        return new UserDetails(string, string2, string3, string4, this.userManager.isAdmin(userProfile.getUserKey()), this.userManager.isSystemAdmin(userProfile.getUserKey()));
    }
}

