/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.audit.entity.AuditAuthor;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.lighthouse.service.user.SecurityUserService;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u000eH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0013\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/lighthouse/service/user/JiraSecurityUserService;", "Lcom/atlassian/lighthouse/service/user/SecurityUserService;", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "groupManager", "Lcom/atlassian/jira/security/groups/GroupManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "securityGroupName", "", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/jira/security/GlobalPermissionManager;Lcom/atlassian/jira/security/groups/GroupManager;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Ljava/lang/String;Lcom/atlassian/sal/api/user/UserManager;)V", "getActiveSystemAdminsUsernames", "", "getSysAdminEmailAddresses", "", "()[Ljava/lang/String;", "getSystemAdminGroupNames", "getUserKeyByAuditAuthor", "auditAuthor", "Lcom/atlassian/audit/entity/AuditAuthor;", "getUserKeyByUserName", "userName", "getValidSecurityGroupUserEmails", "isSystemOrAnonymousAuthor", "", "author", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nJiraSecurityUserService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/JiraSecurityUserService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,75:1\n1549#2:76\n1620#2,3:77\n1603#2,9:80\n1855#2:89\n1856#2:91\n1612#2:92\n766#2:95\n857#2,2:96\n1603#2,9:98\n1855#2:107\n1856#2:109\n1612#2:110\n1#3:90\n1#3:108\n37#4,2:93\n37#4,2:111\n*S KotlinDebug\n*F\n+ 1 JiraSecurityUserService.kt\ncom/atlassian/lighthouse/service/user/JiraSecurityUserService\n*L\n22#1:76\n22#1:77,3\n23#1:80,9\n23#1:89\n23#1:91\n23#1:92\n33#1:95\n33#1:96,2\n34#1:98,9\n34#1:107\n34#1:109\n34#1:110\n23#1:90\n34#1:108\n25#1:93,2\n36#1:111,2\n*E\n"})
public final class JiraSecurityUserService
implements SecurityUserService {
    @NotNull
    private final GlobalPermissionManager globalPermissionManager;
    @NotNull
    private final GroupManager groupManager;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final String securityGroupName;
    @NotNull
    private final UserManager userManager;

    public JiraSecurityUserService(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull String securityGroupName, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter(securityGroupName, "securityGroupName");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.securityGroupName = securityGroupName;
        this.userManager = userManager;
    }

    @Override
    @NotNull
    public String[] getSysAdminEmailAddresses() {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getSysAdminEmailAddresses$lambda$2(this)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (String[])v;
    }

    @Override
    @NotNull
    public String[] getValidSecurityGroupUserEmails() {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getValidSecurityGroupUserEmails$lambda$5(this)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (String[])v;
    }

    @Override
    @Nullable
    public String getUserKeyByAuditAuthor(@NotNull AuditAuthor auditAuthor) {
        Intrinsics.checkNotNullParameter(auditAuthor, "auditAuthor");
        if (this.isSystemOrAnonymousAuthor(auditAuthor)) {
            return auditAuthor.getId();
        }
        return (String)this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getUserKeyByAuditAuthor$lambda$6(this, auditAuthor)).call();
    }

    @Override
    @Nullable
    public String getUserKeyByUserName(@NotNull String userName) {
        Intrinsics.checkNotNullParameter(userName, "userName");
        return (String)this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getUserKeyByUserName$lambda$7(this, userName)).call();
    }

    private final Collection<String> getActiveSystemAdminsUsernames() {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getActiveSystemAdminsUsernames$lambda$8(this)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Collection)v;
    }

    private final Collection<String> getSystemAdminGroupNames() {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraSecurityUserService.getSystemAdminGroupNames$lambda$9(this)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Collection)v;
    }

    private final boolean isSystemOrAnonymousAuthor(AuditAuthor author) {
        return Intrinsics.areEqual(author.getId(), AuditAuthor.SYSTEM_AUTHOR.getId()) || Intrinsics.areEqual(author.getId(), AuditAuthor.ANONYMOUS_AUTHOR.getId());
    }

    @Override
    public boolean isSecurityGroupSetup() {
        return SecurityUserService.DefaultImpls.isSecurityGroupSetup(this);
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] getSysAdminEmailAddresses$lambda$2(JiraSecurityUserService this$0) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Iterable $this$map$iv = this$0.getActiveSystemAdminsUsernames();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void username;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this$0.userManager.getUserProfile((String)username));
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            UserProfile it = (UserProfile)element$iv$iv;
            boolean bl2 = false;
            UserProfile userProfile = it;
            if ((userProfile != null ? userProfile.getEmail() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static final String[] getValidSecurityGroupUserEmails$lambda$5(JiraSecurityUserService this$0) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Collection collection = this$0.groupManager.getUsersInGroup(this$0.securityGroupName);
        Intrinsics.checkNotNullExpressionValue(collection, "getUsersInGroup(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl = false;
            if (!it.isActive()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ApplicationUser it = (ApplicationUser)element$iv$iv;
            boolean bl2 = false;
            if (it.getEmailAddress() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = CollectionsKt.distinct((List)destination$iv$iv);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new String[0]);
    }

    private static final String getUserKeyByAuditAuthor$lambda$6(JiraSecurityUserService this$0, AuditAuthor $auditAuthor) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($auditAuthor, "$auditAuthor");
        UserProfile userProfile = this$0.userManager.getUserProfile($auditAuthor.getName());
        return userProfile != null && (userProfile = userProfile.getUserKey()) != null ? userProfile.getStringValue() : null;
    }

    private static final String getUserKeyByUserName$lambda$7(JiraSecurityUserService this$0, String $userName) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($userName, "$userName");
        UserProfile userProfile = this$0.userManager.getUserProfile($userName);
        return userProfile != null && (userProfile = userProfile.getUserKey()) != null ? userProfile.getStringValue() : null;
    }

    private static final Collection getActiveSystemAdminsUsernames$lambda$8(JiraSecurityUserService this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.groupManager.getNamesOfDirectMembersOfGroups(this$0.getSystemAdminGroupNames(), 100);
    }

    private static final Collection getSystemAdminGroupNames$lambda$9(JiraSecurityUserService this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return this$0.globalPermissionManager.getGroupNamesWithPermission(GlobalPermissionKey.SYSTEM_ADMIN);
    }
}

