/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user;

import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u000e\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/lighthouse/service/user/JiraUserManagerService;", "", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "(Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;Lcom/atlassian/sal/api/user/UserManager;)V", "getUserKey", "Lcom/atlassian/sal/api/user/UserKey;", "username", "", "isAdminCacheLookup", "", "userKey", "isSysAdminOrAdmin", "atlassian-lighthouse-core"})
public final class JiraUserManagerService {
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;
    @NotNull
    private final UserManager userManager;

    public JiraUserManagerService(@NotNull JiraThreadLocalUtil jiraThreadLocalUtil, @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
        this.userManager = userManager;
    }

    public final boolean isSysAdminOrAdmin(@Nullable String username) {
        if (username == null) {
            return false;
        }
        UserKey userKey = this.getUserKey(username);
        return this.isAdminCacheLookup(userKey);
    }

    private final boolean isAdminCacheLookup(UserKey userKey) {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraUserManagerService.isAdminCacheLookup$lambda$0(this, userKey)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Boolean)v;
    }

    private final UserKey getUserKey(String username) {
        UserProfile userProfile = this.userManager.getUserProfile(username);
        boolean bl = false;
        UserProfile userProfile2 = userProfile;
        Object object = userProfile2 != null ? userProfile2.getUserKey() : null;
        if (object == null) {
            throw new IllegalStateException("User key not found with username: " + username);
        }
        return object;
    }

    private static final Boolean isAdminCacheLookup$lambda$0(JiraUserManagerService this$0, UserKey $userKey) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($userKey, "$userKey");
        return this$0.userManager.isAdmin($userKey);
    }
}

