/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.cache;

import com.atlassian.bitbucket.event.permission.GlobalPermissionGrantedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionModifiedEvent;
import com.atlassian.bitbucket.event.permission.GlobalPermissionRevokedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import com.atlassian.lighthouse.util.matchers.permissions.BitbucketPermissionFunctions;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u001c\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001aH\u0007J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\"H\u0007J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020$H\u0007J\u0010\u0010%\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020&H\u0007J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020(H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/atlassian/lighthouse/service/user/cache/BitbucketCachedAdminUserUpdater;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "cachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;Lcom/atlassian/event/api/EventPublisher;)V", "afterPropertiesSet", "", "destroy", "handleGlobalPermissionUpdated", "newPermission", "Lcom/atlassian/bitbucket/permission/Permission;", "oldPermission", "handleGroupMembershipUpdated", "groupName", "", "onDirectoryCreatedEvent", "event", "Lcom/atlassian/crowd/event/directory/DirectoryCreatedEvent;", "onDirectoryDeletedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryDeletedEvent;", "onDirectoryUpdatedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryUpdatedEvent;", "onGlobalPermissionGranted", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionGrantedEvent;", "onGlobalPermissionModified", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionModifiedEvent;", "onGlobalPermissionRevoked", "Lcom/atlassian/bitbucket/event/permission/GlobalPermissionRevokedEvent;", "onGroupMembershipsCreated", "Lcom/atlassian/crowd/event/group/GroupMembershipsCreatedEvent;", "onGroupMembershipsDeleted", "Lcom/atlassian/crowd/event/group/GroupMembershipsDeletedEvent;", "onUserDeleted", "Lcom/atlassian/crowd/event/user/UsersDeletedEvent;", "onUserRenamed", "Lcom/atlassian/crowd/event/user/UserRenamedEvent;", "atlassian-lighthouse-core"})
public final class BitbucketCachedAdminUserUpdater
implements InitializingBean,
DisposableBean {
    @NotNull
    private final CachedAdminGroupService cachedAdminGroupService;
    @NotNull
    private final CachedAdminUserService cachedAdminUserService;
    @NotNull
    private final EventPublisher eventPublisher;

    public BitbucketCachedAdminUserUpdater(@NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        this.cachedAdminGroupService = cachedAdminGroupService;
        this.cachedAdminUserService = cachedAdminUserService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public final void onUserDeleted(@NotNull UsersDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Collection collection = event.getUsernames();
        Intrinsics.checkNotNullExpressionValue(collection, "getUsernames(...)");
        this.cachedAdminUserService.rebuildAdminUserCacheIfExists(collection);
    }

    @EventListener
    public final void onUserRenamed(@NotNull UserRenamedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onGlobalPermissionGranted(@NotNull GlobalPermissionGrantedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        BitbucketCachedAdminUserUpdater.handleGlobalPermissionUpdated$default(this, permission, null, 2, null);
    }

    @EventListener
    public final void onGlobalPermissionModified(@NotNull GlobalPermissionModifiedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        this.handleGlobalPermissionUpdated(permission, event.getOldValue());
    }

    @EventListener
    public final void onGlobalPermissionRevoked(@NotNull GlobalPermissionRevokedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Permission permission = event.getPermission();
        Intrinsics.checkNotNullExpressionValue(permission, "getPermission(...)");
        BitbucketCachedAdminUserUpdater.handleGlobalPermissionUpdated$default(this, permission, null, 2, null);
    }

    @EventListener
    public final void onGroupMembershipsCreated(@NotNull GroupMembershipsCreatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.handleGroupMembershipUpdated(string);
    }

    @EventListener
    public final void onGroupMembershipsDeleted(@NotNull GroupMembershipsDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.handleGroupMembershipUpdated(string);
    }

    @EventListener
    public final void onDirectoryCreatedEvent(@NotNull DirectoryCreatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onDirectoryDeletedEvent(@NotNull DirectoryDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onDirectoryUpdatedEvent(@NotNull DirectoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private final void handleGlobalPermissionUpdated(Permission newPermission, Permission oldPermission) {
        if (BitbucketPermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(newPermission) || BitbucketPermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(oldPermission)) {
            this.cachedAdminUserService.rebuildCache();
        }
    }

    static /* synthetic */ void handleGlobalPermissionUpdated$default(BitbucketCachedAdminUserUpdater bitbucketCachedAdminUserUpdater, Permission permission, Permission permission2, int n, Object object) {
        if ((n & 2) != 0) {
            permission2 = null;
        }
        bitbucketCachedAdminUserUpdater.handleGlobalPermissionUpdated(permission, permission2);
    }

    private final void handleGroupMembershipUpdated(String groupName) {
        if (this.cachedAdminGroupService.isGroupNameInSysAdminOrAdminCache(groupName)) {
            this.cachedAdminUserService.rebuildCache();
        }
    }
}

