/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.cache;

import com.atlassian.crowd.event.directory.DirectoryCreatedEvent;
import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.directory.DirectoryUpdatedEvent;
import com.atlassian.crowd.event.group.GroupDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsDeletedEvent;
import com.atlassian.crowd.event.user.UserRenamedEvent;
import com.atlassian.crowd.event.user.UsersDeletedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.permission.GlobalPermissionAddedEvent;
import com.atlassian.jira.event.permission.GlobalPermissionDeletedEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.lighthouse.service.group.cache.CachedAdminGroupService;
import com.atlassian.lighthouse.service.user.cache.CachedAdminUserService;
import com.atlassian.lighthouse.util.matchers.permissions.JiraPermissionFunctions;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020#H\u0007J\u0010\u0010$\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020%H\u0007J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020'H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/atlassian/lighthouse/service/user/cache/JiraCachedAdminUserUpdater;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "cachedAdminGroupService", "Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;", "cachedAdminUserService", "Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "(Lcom/atlassian/lighthouse/service/group/cache/CachedAdminGroupService;Lcom/atlassian/lighthouse/service/user/cache/CachedAdminUserService;Lcom/atlassian/event/api/EventPublisher;)V", "afterPropertiesSet", "", "destroy", "handleGlobalPermissionUpdated", "globalPermissionKey", "Lcom/atlassian/jira/permission/GlobalPermissionKey;", "handleGroupMembershipUpdated", "groupName", "", "onDirectoryCreatedEvent", "event", "Lcom/atlassian/crowd/event/directory/DirectoryCreatedEvent;", "onDirectoryDeletedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryDeletedEvent;", "onDirectoryUpdatedEvent", "Lcom/atlassian/crowd/event/directory/DirectoryUpdatedEvent;", "onGlobalPermissionAddedEvent", "Lcom/atlassian/jira/event/permission/GlobalPermissionAddedEvent;", "onGlobalPermissionDeletedEvent", "Lcom/atlassian/jira/event/permission/GlobalPermissionDeletedEvent;", "onGroupDeleted", "Lcom/atlassian/crowd/event/group/GroupDeletedEvent;", "onGroupMembershipsCreated", "Lcom/atlassian/crowd/event/group/GroupMembershipsCreatedEvent;", "onGroupMembershipsDeleted", "Lcom/atlassian/crowd/event/group/GroupMembershipsDeletedEvent;", "onUserRenamed", "Lcom/atlassian/crowd/event/user/UserRenamedEvent;", "onUsersDeleted", "Lcom/atlassian/crowd/event/user/UsersDeletedEvent;", "atlassian-lighthouse-core"})
public final class JiraCachedAdminUserUpdater
implements InitializingBean,
DisposableBean {
    @NotNull
    private final CachedAdminGroupService cachedAdminGroupService;
    @NotNull
    private final CachedAdminUserService cachedAdminUserService;
    @NotNull
    private final EventPublisher eventPublisher;

    public JiraCachedAdminUserUpdater(@NotNull CachedAdminGroupService cachedAdminGroupService, @NotNull CachedAdminUserService cachedAdminUserService, @NotNull EventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter(cachedAdminGroupService, "cachedAdminGroupService");
        Intrinsics.checkNotNullParameter(cachedAdminUserService, "cachedAdminUserService");
        Intrinsics.checkNotNullParameter(eventPublisher, "eventPublisher");
        this.cachedAdminGroupService = cachedAdminGroupService;
        this.cachedAdminUserService = cachedAdminUserService;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public final void onUsersDeleted(@NotNull UsersDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        Collection collection = event.getUsernames();
        Intrinsics.checkNotNullExpressionValue(collection, "getUsernames(...)");
        this.cachedAdminUserService.rebuildAdminUserCacheIfExists(collection);
    }

    @EventListener
    public final void onUserRenamed(@NotNull UserRenamedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onGroupMembershipsCreated(@NotNull GroupMembershipsCreatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.handleGroupMembershipUpdated(string);
    }

    @EventListener
    public final void onGroupMembershipsDeleted(@NotNull GroupMembershipsDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.handleGroupMembershipUpdated(string);
    }

    @EventListener
    public final void onGroupDeleted(@NotNull GroupDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        String string = event.getGroupName();
        Intrinsics.checkNotNullExpressionValue(string, "getGroupName(...)");
        this.handleGroupMembershipUpdated(string);
    }

    @EventListener
    public final void onGlobalPermissionAddedEvent(@NotNull GlobalPermissionAddedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GlobalPermissionKey globalPermissionKey = event.getGlobalPermissionType().getGlobalPermissionKey();
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "getGlobalPermissionKey(...)");
        this.handleGlobalPermissionUpdated(globalPermissionKey);
    }

    @EventListener
    public final void onGlobalPermissionDeletedEvent(@NotNull GlobalPermissionDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        GlobalPermissionKey globalPermissionKey = event.getGlobalPermissionType().getGlobalPermissionKey();
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "getGlobalPermissionKey(...)");
        this.handleGlobalPermissionUpdated(globalPermissionKey);
    }

    @EventListener
    public final void onDirectoryCreatedEvent(@NotNull DirectoryCreatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onDirectoryDeletedEvent(@NotNull DirectoryDeletedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    @EventListener
    public final void onDirectoryUpdatedEvent(@NotNull DirectoryUpdatedEvent event) {
        Intrinsics.checkNotNullParameter(event, "event");
        this.cachedAdminUserService.rebuildCache();
    }

    private final void handleGroupMembershipUpdated(String groupName) {
        if (this.cachedAdminGroupService.isGroupNameInSysAdminOrAdminCache(groupName)) {
            this.cachedAdminUserService.rebuildCache();
        }
    }

    private final void handleGlobalPermissionUpdated(GlobalPermissionKey globalPermissionKey) {
        if (JiraPermissionFunctions.INSTANCE.isAdminOrSysAdminPermission(globalPermissionKey)) {
            this.cachedAdminUserService.rebuildCache();
        }
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }
}

