/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.service.user.supplier;

import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.thread.JiraThreadLocalUtil;
import com.atlassian.lighthouse.service.user.supplier.AdminUsernamesFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/lighthouse/service/user/supplier/JiraAdminUsernamesFinder;", "Lcom/atlassian/lighthouse/service/user/supplier/AdminUsernamesFinder;", "globalPermissionManager", "Lcom/atlassian/jira/security/GlobalPermissionManager;", "groupManager", "Lcom/atlassian/jira/security/groups/GroupManager;", "jiraThreadLocalUtil", "Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;", "(Lcom/atlassian/jira/security/GlobalPermissionManager;Lcom/atlassian/jira/security/groups/GroupManager;Lcom/atlassian/jira/util/thread/JiraThreadLocalUtil;)V", "getAdminUsernames", "", "", "getGroupNamesWithPermission", "", "permissionKey", "Lcom/atlassian/jira/permission/GlobalPermissionKey;", "getSysAdminUsernames", "getUsernames", "isSysAdminOrAdminUncached", "", "username", "atlassian-lighthouse-core"})
@SourceDebugExtension(value={"SMAP\nJiraAdminUsernamesFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JiraAdminUsernamesFinder.kt\ncom/atlassian/lighthouse/service/user/supplier/JiraAdminUsernamesFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,41:1\n1360#2:42\n1446#2,5:43\n1549#2:48\n1620#2,3:49\n*S KotlinDebug\n*F\n+ 1 JiraAdminUsernamesFinder.kt\ncom/atlassian/lighthouse/service/user/supplier/JiraAdminUsernamesFinder\n*L\n30#1:42\n30#1:43,5\n31#1:48\n31#1:49,3\n*E\n"})
public final class JiraAdminUsernamesFinder
implements AdminUsernamesFinder {
    @NotNull
    private final GlobalPermissionManager globalPermissionManager;
    @NotNull
    private final GroupManager groupManager;
    @NotNull
    private final JiraThreadLocalUtil jiraThreadLocalUtil;

    public JiraAdminUsernamesFinder(@NotNull GlobalPermissionManager globalPermissionManager, @NotNull GroupManager groupManager, @NotNull JiraThreadLocalUtil jiraThreadLocalUtil) {
        Intrinsics.checkNotNullParameter(globalPermissionManager, "globalPermissionManager");
        Intrinsics.checkNotNullParameter(groupManager, "groupManager");
        Intrinsics.checkNotNullParameter(jiraThreadLocalUtil, "jiraThreadLocalUtil");
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.jiraThreadLocalUtil = jiraThreadLocalUtil;
    }

    @Override
    @NotNull
    public Set<String> getAdminUsernames() {
        GlobalPermissionKey globalPermissionKey = GlobalPermissionKey.ADMINISTER;
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "ADMINISTER");
        return this.getUsernames(globalPermissionKey);
    }

    @Override
    @NotNull
    public Set<String> getSysAdminUsernames() {
        GlobalPermissionKey globalPermissionKey = GlobalPermissionKey.SYSTEM_ADMIN;
        Intrinsics.checkNotNullExpressionValue(globalPermissionKey, "SYSTEM_ADMIN");
        return this.getUsernames(globalPermissionKey);
    }

    @Override
    public boolean isSysAdminOrAdminUncached(@NotNull String username) {
        Intrinsics.checkNotNullParameter(username, "username");
        String string = "Not yet used in Jira";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final Set<String> getUsernames(GlobalPermissionKey permissionKey) {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraAdminUsernamesFinder.getUsernames$lambda$2(this, permissionKey)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Set)v;
    }

    private final Collection<String> getGroupNamesWithPermission(GlobalPermissionKey permissionKey) {
        Object v = this.jiraThreadLocalUtil.wrap(() -> JiraAdminUsernamesFinder.getGroupNamesWithPermission$lambda$3(this, permissionKey)).call();
        Intrinsics.checkNotNullExpressionValue(v, "call(...)");
        return (Collection)v;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set getUsernames$lambda$2(JiraAdminUsernamesFinder this$0, GlobalPermissionKey $permissionKey) {
        void $this$mapTo$iv$iv;
        Iterable list$iv$iv;
        String it;
        Iterable $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($permissionKey, "$permissionKey");
        Iterable $this$flatMap$iv = this$0.getGroupNamesWithPermission($permissionKey);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            Collection collection = this$0.groupManager.getUsersInGroup(it, Boolean.valueOf(true));
            Intrinsics.checkNotNullExpressionValue(collection, "getUsersInGroup(...)");
            list$iv$iv = collection;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$flatMapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            list$iv$iv = (ApplicationUser)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getUsername());
        }
        return CollectionsKt.toSet((List)destination$iv$iv);
    }

    private static final Collection getGroupNamesWithPermission$lambda$3(JiraAdminUsernamesFinder this$0, GlobalPermissionKey $permissionKey) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($permissionKey, "$permissionKey");
        return this$0.globalPermissionManager.getGroupNamesWithPermission($permissionKey);
    }
}

