/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.lighthouse.util.matchers.permissions;

import com.atlassian.audit.entity.AuditEntity;
import com.atlassian.lighthouse.matchers.audit.log.AuditEntityExtensionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u0010\u0010\u0013\u001a\u00020\u00042\b\u0010\u0014\u001a\u0004\u0018\u00010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/lighthouse/util/matchers/permissions/ConfluencePermissionFunctions;", "", "()V", "adminGroupPermissionDemoted", "", "it", "Lcom/atlassian/audit/entity/AuditEntity;", "adminGroupPermissionElevated", "adminUserPermissionDemoted", "adminUserPermissionElevated", "getAffectedGroupName", "", "auditEntity", "getAffectedUserName", "getChangedFromPermissionType", "getChangedToPermissionType", "getTargetGroupName", "getTargetUserNameWhenPermissionAdded", "getTargetUserNameWhenPermissionRemoved", "isAdminOrSysAdminPermission", "permissionType", "atlassian-lighthouse-core"})
public final class ConfluencePermissionFunctions {
    @NotNull
    public static final ConfluencePermissionFunctions INSTANCE = new ConfluencePermissionFunctions();

    private ConfluencePermissionFunctions() {
    }

    public final boolean adminGroupPermissionDemoted(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.getAffectedGroupName(it) != null && this.isAdminOrSysAdminPermission(this.getChangedFromPermissionType(it));
    }

    public final boolean adminGroupPermissionElevated(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.getAffectedGroupName(it) != null && this.isAdminOrSysAdminPermission(this.getChangedToPermissionType(it));
    }

    public final boolean adminUserPermissionDemoted(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.getTargetUserNameWhenPermissionRemoved(it) != null && this.isAdminOrSysAdminPermission(this.getChangedFromPermissionType(it));
    }

    public final boolean adminUserPermissionElevated(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this.getTargetUserNameWhenPermissionAdded(it) != null && this.isAdminOrSysAdminPermission(this.getChangedToPermissionType(it));
    }

    @Nullable
    public final String getTargetGroupName(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = AuditEntityExtensionsKt.getAffectedObjectName(it, "Group");
        if (string == null) {
            string = AuditEntityExtensionsKt.getChangedValueTo(it, "audit.logging.com.atlassian.confluence.security.SpacePermission.getGroup");
        }
        return string;
    }

    @Nullable
    public final String getChangedToPermissionType(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = AuditEntityExtensionsKt.getChangedValueTo(it, "Type");
        if (string == null) {
            string = AuditEntityExtensionsKt.getChangedValueTo(it, "audit.logging.com.atlassian.confluence.security.SpacePermission.getType");
        }
        return string;
    }

    @Nullable
    public final String getChangedFromPermissionType(@NotNull AuditEntity it) {
        Intrinsics.checkNotNullParameter(it, "it");
        String string = AuditEntityExtensionsKt.getChangedValueFrom(it, "Type");
        if (string == null) {
            string = AuditEntityExtensionsKt.getChangedValueFrom(it, "audit.logging.com.atlassian.confluence.security.SpacePermission.getType");
        }
        return string;
    }

    public final boolean isAdminOrSysAdminPermission(@Nullable String permissionType) {
        return Intrinsics.areEqual("SYSTEMADMINISTRATOR", permissionType) || Intrinsics.areEqual("ADMINISTRATECONFLUENCE", permissionType);
    }

    @Nullable
    public final String getAffectedGroupName(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return AuditEntityExtensionsKt.getAffectedObjectName(auditEntity, "Group");
    }

    @Nullable
    public final String getAffectedUserName(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return AuditEntityExtensionsKt.getAffectedObjectName(auditEntity, "User");
    }

    @Nullable
    public final String getTargetUserNameWhenPermissionRemoved(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return AuditEntityExtensionsKt.getChangedValueFrom(auditEntity, "audit.logging.com.atlassian.user.User");
    }

    @Nullable
    public final String getTargetUserNameWhenPermissionAdded(@NotNull AuditEntity auditEntity) {
        Intrinsics.checkNotNullParameter(auditEntity, "auditEntity");
        return AuditEntityExtensionsKt.getChangedValueTo(auditEntity, "audit.logging.com.atlassian.user.User");
    }
}

