/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.cloud.connect.companion.client;

import com.atlassian.plugins.cloud.connect.companion.client.CloudLink;
import com.atlassian.plugins.cloud.connect.companion.client.CloudObjectMapper;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequest;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestService;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceNotAvailableException;
import com.atlassian.plugins.cloud.connect.companion.client.CloudRequestServiceTranslatingProxy;
import com.atlassian.plugins.cloud.connect.companion.client.CloudResponse;
import com.atlassian.plugins.cloud.connect.companion.client.GenericTypeReference;
import com.atlassian.plugins.cloud.connect.companion.client.IncompatibleServiceException;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class CloudRequestServiceLocator
implements InitializingBean,
DisposableBean,
CloudRequestService {
    private static final Logger log = LoggerFactory.getLogger(CloudRequestServiceLocator.class);
    private ServiceTracker<ServiceReference<?>, ?> serviceTracker;
    private final BundleContext bundleContext;

    public CloudRequestServiceLocator(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    @Deprecated
    public CloudRequestService getCloudRequestService() throws CloudRequestServiceNotAvailableException {
        log.debug("Getting CloudRequestService");
        if (this.isPresent()) {
            return new CloudRequestServiceTranslatingProxy(this.serviceTracker);
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    public void afterPropertiesSet() {
        this.serviceTracker = new ServiceTracker(this.bundleContext, "com.atlassian.plugins.cloud.connect.inter.api.CloudRequestServiceInternal", null);
        this.serviceTracker.open();
        log.info("Initialized CloudRequestServiceProvider");
    }

    public void destroy() {
        this.serviceTracker.close();
        this.serviceTracker = null;
        log.info("Closed service tracker for CloudRequestService");
    }

    @Override
    public <R, T> CloudResponse<R> sendRequest(CloudRequest<T> request, Class<R> responseType, CloudObjectMapper mapper) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            return new CloudRequestServiceTranslatingProxy(this.serviceTracker).sendRequest(request, responseType, mapper);
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    @Override
    public <R, T> CloudResponse<R> sendRequest(CloudRequest<T> request, GenericTypeReference<R> responseType, CloudObjectMapper mapper) throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            return new CloudRequestServiceTranslatingProxy(this.serviceTracker).sendRequest(request, responseType, mapper);
        }
        throw new CloudRequestServiceNotAvailableException();
    }

    @Override
    public boolean isPresent() {
        return this.serviceTracker != null && this.serviceTracker.getService() != null;
    }

    @Override
    public Optional<CloudLink> getCloudLink() throws CloudRequestServiceNotAvailableException, IncompatibleServiceException {
        if (this.isPresent()) {
            return new CloudRequestServiceTranslatingProxy(this.serviceTracker).getCloudLink();
        }
        throw new CloudRequestServiceNotAvailableException();
    }
}

