/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.conversion;

import com.aspose.cells.FontConfigs;
import com.aspose.cells.License;
import com.aspose.slides.FontsLoader;
import com.aspose.words.FontSettings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsposeUtils {
    private static final Logger log = LoggerFactory.getLogger(AsposeUtils.class);
    private static final String PROP_SEARCH_FONT_PATH = "confluence.document.conversion.fontpath";
    private static final String PROP_WORDS_DEFAULT_FONT_NAME = "confluence.document.conversion.words.defaultfontname";
    private static final String PROP_SLIDES_DEFAULT_REGULAR_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.regular";
    private static final String PROP_SLIDES_DEFAULT_ASIAN_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.asian";
    private static final String PROP_SLIDES_DEFAULT_SYMBOL_FONT_NAME = "confluence.document.conversion.slides.defaultfontname.symbol";
    private static final String OS_NAME = System.getProperty("os.name");
    private static final boolean IS_OS_WINDOWS = OS_NAME.startsWith("Windows");
    private static final boolean IS_OS_MAC = OS_NAME.startsWith("Mac");
    private static final String DEFAULT_SEARCH_FONT_PATH = IS_OS_WINDOWS ? System.getenv("WINDIR") + "\\Fonts" : (IS_OS_MAC ? "/Library/Fonts" : "/usr/share/fonts");
    private static final String DEFAULT_SLIDES_DEFAULT_ASIAN_FONT = "TakaoPGothic";
    public static final String SLIDES_DEFAULT_REGULAR_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.regular");
    public static final String SLIDES_DEFAULT_ASIAN_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.asian", "TakaoPGothic");
    public static final String SLIDES_DEFAULT_SYMBOL_FONT = System.getProperty("confluence.document.conversion.slides.defaultfontname.symbol");
    private static final String AsposeLicense = "<?xml version=\"1.0\"?>\n<License>\n    <Data>\n        <LicensedTo>Atlassian Pty Ltd</LicensedTo>\n        <EmailTo>jponting@atlassian.com</EmailTo>\n        <LicenseType>Site OEM</LicenseType>\n        <LicenseNote>Up To 10 Developers And Unlimited Deployment Locations</LicenseNote>\n        <OrderID>231017025751</OrderID>\n        <UserID>964788</UserID>\n        <OEM>This is a redistributable license</OEM>\n        <Products>\n            <Product>Aspose.Total for Java</Product>\n        </Products>\n        <EditionType>Enterprise</EditionType>\n        <SerialNumber>abc6ecc7-f143-43f3-9c82-ea4ed3557474</SerialNumber>\n        <SubscriptionExpiry>20241120</SubscriptionExpiry>\n        <LicenseVersion>3.0</LicenseVersion>\n        <LicenseInstructions>https://purchase.aspose.com/policies/use-license</LicenseInstructions>\n    </Data>\n    <Signature>ziXtqAJcyILSfWx9sOR9da0Wbeba+YjGal0lvVEDiTYE74Uh7V0GxQYmDnP689EicDVK+0U8n79LXJbnAtUUgLnPxp62aVKIiKJzlOLib/13I0Bucm77ts3R1+2sVFhS7FQuRbx0H0uPobPbP5+vAXDD5hfuQC8BdNBOuBJ4mkY=</Signature>\n</License>";

    public static void license() {
        log.info("Loading licences for Aspose");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(AsposeUtils.class.getClassLoader());
            try {
                log.debug("Loading license for aspose-psd");
                com.aspose.psd.License licensePsd = new com.aspose.psd.License();
                licensePsd.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-psd", (Throwable)e);
            }
            try {
                log.debug("Loading license for aspose-imaging");
                com.aspose.imaging.License licenseImg = new com.aspose.imaging.License();
                licenseImg.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-imaging", (Throwable)e);
            }
            try {
                log.debug("Loading license for aspose-slides");
                com.aspose.slides.License licenseSlides = new com.aspose.slides.License();
                licenseSlides.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-slides", (Throwable)e);
            }
            try {
                log.debug("Loading license for aspose-words");
                com.aspose.words.License licenseWords = new com.aspose.words.License();
                licenseWords.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-words", (Throwable)e);
            }
            try {
                log.debug("Loading license for aspose-cells");
                License licenseCells = new License();
                licenseCells.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-cells", (Throwable)e);
            }
            try {
                log.debug("Loading license for aspose-pdf");
                com.aspose.pdf.License licensePdf = new com.aspose.pdf.License();
                licensePdf.setLicense((InputStream)new ByteArrayInputStream(AsposeLicense.getBytes()));
            }
            catch (Exception e) {
                log.error("Failed to load license for aspose-pdf", (Throwable)e);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    public static void configureFonts() {
        log.info("Configuring Aspose Fonts");
        String defaultWordsFont = System.getProperty(PROP_WORDS_DEFAULT_FONT_NAME);
        if (defaultWordsFont != null) {
            log.info("Setting default font for aspose words to [{}]", (Object)defaultWordsFont);
            FontSettings.getDefaultInstance().getSubstitutionSettings().getDefaultFontSubstitution().setDefaultFontName(defaultWordsFont);
        }
        String path = System.getProperty(PROP_SEARCH_FONT_PATH, DEFAULT_SEARCH_FONT_PATH);
        File basePath = new File(path);
        log.info("Trying font path [{}]", (Object)path);
        if (!basePath.isDirectory() && !path.equals(DEFAULT_SEARCH_FONT_PATH)) {
            log.warn("Configured font path [{}] is not a directory; trying again with the default path [{}]", (Object)path, (Object)DEFAULT_SEARCH_FONT_PATH);
            path = DEFAULT_SEARCH_FONT_PATH;
            if (!new File(path).isDirectory()) {
                log.warn("Default font path [{}] is not a directory, cannot configure fonts", (Object)path);
                return;
            }
        }
        log.info("Configuring aspose-words with font path [{}]", (Object)path);
        FontSettings.getDefaultInstance().setFontsFolder(path, true);
        try {
            log.info("Loading aspose-slides external fonts from [{}]", (Object)path);
            FontsLoader.loadExternalFonts((String[])new String[]{path});
        }
        catch (com.aspose.slides.exceptions.Exception ex) {
            log.warn("aspose-slides failed to load external fonts from path [{}]", (Object)path, (Object)ex);
        }
        log.info("Configuring aspose-cells with font path [{}]", (Object)path);
        FontConfigs.setFontFolder((String)path, (boolean)true);
    }
}

