/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharepage.notifications.recipients;

import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.NonUserBasedRecipientsProviderTemplate;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.plugins.sharepage.notifications.context.ShareNotificationAddress;
import com.atlassian.confluence.plugins.sharepage.notifications.payload.ShareContentPayload;
import com.atlassian.plugin.notifications.api.medium.DefaultNotificationAddress;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Option;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class ShareContentAddressRecipientProvider
extends NonUserBasedRecipientsProviderTemplate<ShareContentPayload> {
    private static final ImmutableList<UserRole> ROLES = ImmutableList.of((Object)new ConfluenceUserRole("SHARE_CONTENT"));

    public ShareContentAddressRecipientProvider() {
        super(ShareContentPayload.class);
    }

    public Iterable<NotificationAddress> nonUserBasedRecipientsFor(Notification<ShareContentPayload> notification) {
        this.verifyPayloadMatches(notification);
        return this.computeNonUserBasedRecipients(notification);
    }

    protected Iterable<NotificationAddress> computeNonUserBasedRecipients(Notification<ShareContentPayload> notification) {
        LinkedList<DefaultNotificationAddress> notificationAddressList = new LinkedList<DefaultNotificationAddress>();
        Map<String, Set<String>> cleanedEmails = this.getCleanedEmailsWithGroups(notification);
        if (cleanedEmails != null) {
            cleanedEmails.forEach((key, value) -> notificationAddressList.addAll(value.stream().map(group -> new ShareNotificationAddress((Option<String>)Option.option((Object)this.getEmailMediumKey()), (String)key, (String)group)).toList()));
        } else {
            notificationAddressList.addAll(this.getCleanedEmails(notification).stream().map(email -> new DefaultNotificationAddress(this.getEmailMediumKey(), email)).toList());
        }
        return ImmutableList.copyOf(notificationAddressList);
    }

    private Set<String> getCleanedEmails(Notification<ShareContentPayload> notification) {
        return ((ShareContentPayload)notification.getPayload()).getEmails();
    }

    private Map<String, Set<String>> getCleanedEmailsWithGroups(Notification<ShareContentPayload> notification) {
        return ((ShareContentPayload)notification.getPayload()).getEmailsWithGroups();
    }

    private String getEmailMediumKey() {
        return "mail";
    }

    public Iterable<UserRole> getUserRoles() {
        return ROLES;
    }
}

