/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharepage.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.confluence.plugins.sharepage.api.SharePageService;
import com.atlassian.confluence.plugins.sharepage.api.ShareRequest;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class ShareResource {
    private final SharePageService sharePageService;

    @Inject
    public ShareResource(SharePageService sharePageService) {
        this.sharePageService = sharePageService;
    }

    @POST
    @Path(value="/share")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    @ReadOnlyAccessAllowed
    @ScopesAllowed(requiredScope={"WRITE"})
    public Response share(ShareRequest shareRequest) {
        this.sharePageService.share(shareRequest);
        return Response.ok().build();
    }
}

