/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import jakarta.inject.Named;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.poi.util.DefaultTempFileCreationStrategy;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.TempFileCreationStrategy;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/addonengine/addons/analytics/AddonInitialiser;", "Lorg/springframework/beans/factory/InitializingBean;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "<init>", "(Lcom/atlassian/sal/api/ApplicationProperties;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "initExcelTempFileCreationStrategy", "analytics"})
public final class AddonInitialiser
implements InitializingBean {
    @NotNull
    private final ApplicationProperties applicationProperties;
    private final Logger log;

    @Autowired
    public AddonInitialiser(@ComponentImport @NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        this.applicationProperties = applicationProperties;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public void afterPropertiesSet() {
        this.initExcelTempFileCreationStrategy();
    }

    private final void initExcelTempFileCreationStrategy() {
        Path tempPath = ((Path)this.applicationProperties.getLocalHomeDirectory().get()).resolve("temp");
        TempFile.setTempFileCreationStrategy((TempFileCreationStrategy)((TempFileCreationStrategy)new DefaultTempFileCreationStrategy(tempPath.toFile())));
        this.log.debug("Excel temp file path set to '" + tempPath + "'");
    }
}

