/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.event;

import com.addonengine.addons.analytics.event.AsyncAfCEnabledEvent;
import com.addonengine.addons.analytics.event.AsyncLicenseChangedToDcEvent;
import com.addonengine.addons.analytics.service.confluence.LicenseRemovalService;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.license.BaseLicenseDetails;
import com.atlassian.sal.api.license.LicenseChangedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB%\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u001bH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/addonengine/addons/analytics/event/LegacyLicenseCleaner;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "licenseService", "Lcom/atlassian/confluence/license/LicenseService;", "licenseRemovalService", "Lcom/addonengine/addons/analytics/service/confluence/LicenseRemovalService;", "<init>", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/confluence/license/LicenseService;Lcom/addonengine/addons/analytics/service/confluence/LicenseRemovalService;)V", "getEventPublisher", "()Lcom/atlassian/event/api/EventPublisher;", "getLicenseService", "()Lcom/atlassian/confluence/license/LicenseService;", "afterPropertiesSet", "", "destroy", "onLicenseChangedEvent", "event", "Lcom/atlassian/sal/api/license/LicenseChangedEvent;", "onLicenseChangedToDcEvent", "ignored", "Lcom/addonengine/addons/analytics/event/AsyncLicenseChangedToDcEvent;", "onPluginEnabledEvent", "Lcom/atlassian/plugin/event/events/PluginEnabledEvent;", "onAfCEnabledEvent", "Lcom/addonengine/addons/analytics/event/AsyncAfCEnabledEvent;", "Companion", "analytics"})
public final class LegacyLicenseCleaner
implements InitializingBean,
DisposableBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final LicenseService licenseService;
    @NotNull
    private final LicenseRemovalService licenseRemovalService;
    private static final Logger log = LoggerFactory.getLogger((String)"atlassian.plugin");

    @Autowired
    public LegacyLicenseCleaner(@ComponentImport @NotNull EventPublisher eventPublisher, @ComponentImport @NotNull LicenseService licenseService, @NotNull LicenseRemovalService licenseRemovalService) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)licenseService, (String)"licenseService");
        Intrinsics.checkNotNullParameter((Object)licenseRemovalService, (String)"licenseRemovalService");
        this.eventPublisher = eventPublisher;
        this.licenseService = licenseService;
        this.licenseRemovalService = licenseRemovalService;
    }

    @NotNull
    public final EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    @NotNull
    public final LicenseService getLicenseService() {
        return this.licenseService;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public final void onLicenseChangedEvent(@NotNull LicenseChangedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        BaseLicenseDetails newLicense = event.getNewLicense();
        if (newLicense != null && newLicense.isDataCenter()) {
            this.eventPublisher.publish((Object)new AsyncLicenseChangedToDcEvent());
        }
    }

    @EventListener
    public final void onLicenseChangedToDcEvent(@NotNull AsyncLicenseChangedToDcEvent ignored) {
        Intrinsics.checkNotNullParameter((Object)ignored, (String)"ignored");
        log.info("Confluence is running with a DC license. Removing legacy licenses of AfC (if exist)");
        this.licenseRemovalService.removeIfExist();
    }

    @EventListener
    public final void onPluginEnabledEvent(@NotNull PluginEnabledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (Intrinsics.areEqual((Object)"com.addonengine.analytics", (Object)event.getPlugin().getKey())) {
            this.eventPublisher.publish((Object)new AsyncAfCEnabledEvent());
        }
    }

    @EventListener
    public final void onAfCEnabledEvent(@NotNull AsyncAfCEnabledEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.licenseService.isLicensedForDataCenterOrExempt()) {
            log.debug("AfC has been enabled. Removing legacy licenses of AfC (if exist) from Data Center");
            this.licenseRemovalService.removeIfExist();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/addonengine/addons/analytics/event/LegacyLicenseCleaner$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

