/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest;

import com.addonengine.addons.analytics.rest.dto.ErrorDto;
import com.addonengine.addons.analytics.rest.dto.ErrorResponseDto;
import com.addonengine.addons.analytics.rest.filterbinding.UserIsSystemAdmin;
import com.addonengine.addons.analytics.rest.filterbinding.ValidAddonLicense;
import com.addonengine.addons.analytics.service.Event;
import com.addonengine.addons.analytics.service.EventQuery;
import com.addonengine.addons.analytics.service.EventService;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.io.OutputStream;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/event")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ValidAddonLicense
@UserIsSystemAdmin
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J1\u0010\u000e\u001a\u00020\u000f2\n\b\u0001\u0010\u0010\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u0012\u001a\u0004\u0018\u00010\u00112\n\b\u0001\u0010\u0013\u001a\u0004\u0018\u00010\u0007H\u0007\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/addonengine/addons/analytics/rest/EventResource;", "", "eventService", "Lcom/addonengine/addons/analytics/service/EventService;", "<init>", "(Lcom/addonengine/addons/analytics/service/EventService;)V", "DEFAULT_EXPORT_FROM_DAYS", "", "getDEFAULT_EXPORT_FROM_DAYS", "()J", "DEFAULT_LIMIT", "getDEFAULT_LIMIT", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getEvents", "Ljakarta/ws/rs/core/Response;", "from", "", "to", "limit", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;)Ljakarta/ws/rs/core/Response;", "analytics"})
@SourceDebugExtension(value={"SMAP\nEventResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventResource.kt\ncom/addonengine/addons/analytics/rest/EventResource\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
public final class EventResource {
    @NotNull
    private final EventService eventService;
    private final long DEFAULT_EXPORT_FROM_DAYS;
    private final long DEFAULT_LIMIT;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public EventResource(@NotNull EventService eventService) {
        Intrinsics.checkNotNullParameter((Object)eventService, (String)"eventService");
        this.eventService = eventService;
        this.DEFAULT_EXPORT_FROM_DAYS = 365L;
        this.DEFAULT_LIMIT = 10000L;
        this.mapper = new ObjectMapper();
    }

    public final long getDEFAULT_EXPORT_FROM_DAYS() {
        return this.DEFAULT_EXPORT_FROM_DAYS;
    }

    public final long getDEFAULT_LIMIT() {
        return this.DEFAULT_LIMIT;
    }

    @GET
    @NotNull
    public final Response getEvents(@QueryParam(value="from") @Nullable String from, @QueryParam(value="to") @Nullable String to, @QueryParam(value="limit") @Nullable Long limit) {
        Object actualFrom = null;
        Object actualTo = null;
        try {
            Object object;
            block9: {
                block8: {
                    String it;
                    Object object2;
                    block7: {
                        block6: {
                            object2 = from;
                            if (object2 == null) break block6;
                            it = object2;
                            boolean bl = false;
                            Instant instant = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(from));
                            object2 = instant;
                            if (instant != null) break block7;
                        }
                        Instant instant = Instant.now().minus(this.DEFAULT_EXPORT_FROM_DAYS, ChronoUnit.DAYS);
                        object2 = instant;
                        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"minus(...)");
                    }
                    actualFrom = object2;
                    object = to;
                    if (object == null) break block8;
                    it = object;
                    boolean bl = false;
                    Instant instant = Instant.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(to));
                    object = instant;
                    if (instant != null) break block9;
                }
                Instant instant = Instant.now();
                object = instant;
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            }
            actualTo = object;
        }
        catch (DateTimeParseException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("InvalidDateTimeFormat", "Query string parameter 'from' and 'to' are expected to be ISO date-time format."))).build());
        }
        Long l = limit;
        long actualLimit = l != null ? l : this.DEFAULT_LIMIT;
        Stream<Event> stream = this.eventService.stream(new EventQuery((Instant)actualFrom, (Instant)actualTo));
        Ref.BooleanRef isFirstItem = new Ref.BooleanRef();
        isFirstItem.element = true;
        Response response = Response.ok(arg_0 -> EventResource.getEvents$lambda$4(stream, actualLimit, isFirstItem, this, arg_0)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    private static final Unit getEvents$lambda$4$lambda$2(Ref.BooleanRef $isFirstItem, OutputStream $output, EventResource this$0, Event it) {
        if (!$isFirstItem.element) {
            OutputStream outputStream = $output;
            if (outputStream != null) {
                outputStream.write(44);
            }
        }
        OutputStream outputStream = $output;
        if (outputStream != null) {
            outputStream.write(this$0.mapper.writeValueAsBytes((Object)it));
        }
        $isFirstItem.element = false;
        return Unit.INSTANCE;
    }

    private static final void getEvents$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void getEvents$lambda$4(Stream $stream, long $actualLimit, Ref.BooleanRef $isFirstItem, EventResource this$0, OutputStream output) {
        block1: {
            OutputStream outputStream = output;
            if (outputStream != null) {
                outputStream.write(91);
            }
            $stream.limit($actualLimit).forEach(arg_0 -> EventResource.getEvents$lambda$4$lambda$3(arg_0 -> EventResource.getEvents$lambda$4$lambda$2($isFirstItem, output, this$0, arg_0), arg_0));
            OutputStream outputStream2 = output;
            if (outputStream2 == null) break block1;
            outputStream2.write(93);
        }
    }
}

