/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest;

import com.addonengine.addons.analytics.rest.dto.restrictions.InstanceUserGroupRestrictionDto;
import com.addonengine.addons.analytics.rest.dto.restrictions.NewInstanceUserGroupRestrictionDto;
import com.addonengine.addons.analytics.rest.dto.restrictions.RestrictionsDto;
import com.addonengine.addons.analytics.rest.filterbinding.UserIsAdmin;
import com.addonengine.addons.analytics.rest.filterbinding.ValidAddonLicense;
import com.addonengine.addons.analytics.service.RestrictionsService;
import com.addonengine.addons.analytics.service.confluence.UrlBuilder;
import com.addonengine.addons.analytics.service.confluence.model.Group;
import com.addonengine.addons.analytics.service.model.restrictions.InstanceRestrictions;
import com.addonengine.addons.analytics.service.model.restrictions.UserGroupRestriction;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Path(value="/instance/restrictions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ReadOnlyAccessAllowed
@ValidAddonLicense
@UserIsAdmin
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0007J\u0016\u0010\u000e\u001a\u00020\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\u0006\u0010\u000f\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/addonengine/addons/analytics/rest/InstanceRestrictionsResource;", "", "restrictionsService", "Lcom/addonengine/addons/analytics/service/RestrictionsService;", "urlBuilder", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "<init>", "(Lcom/addonengine/addons/analytics/service/RestrictionsService;Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;)V", "groupProfilePicturePath", "", "getGroupProfilePicturePath", "()Ljava/lang/String;", "getRestrictions", "Ljakarta/ws/rs/core/Response;", "putRestrictions", "restrictions", "Lcom/addonengine/addons/analytics/rest/dto/restrictions/RestrictionsDto;", "Lcom/addonengine/addons/analytics/rest/dto/restrictions/NewInstanceUserGroupRestrictionDto;", "mapRestrictionsToDto", "Lcom/addonengine/addons/analytics/rest/dto/restrictions/InstanceUserGroupRestrictionDto;", "Lcom/addonengine/addons/analytics/service/model/restrictions/InstanceRestrictions;", "analytics"})
@SourceDebugExtension(value={"SMAP\nInstanceRestrictionsResource.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstanceRestrictionsResource.kt\ncom/addonengine/addons/analytics/rest/InstanceRestrictionsResource\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n1563#2:66\n1634#2,3:67\n1563#2:70\n1634#2,3:71\n*S KotlinDebug\n*F\n+ 1 InstanceRestrictionsResource.kt\ncom/addonengine/addons/analytics/rest/InstanceRestrictionsResource\n*L\n44#1:66\n44#1:67,3\n55#1:70\n55#1:71,3\n*E\n"})
public final class InstanceRestrictionsResource {
    @NotNull
    private final RestrictionsService restrictionsService;
    @NotNull
    private final UrlBuilder urlBuilder;
    @NotNull
    private final String groupProfilePicturePath;

    @Inject
    public InstanceRestrictionsResource(@NotNull RestrictionsService restrictionsService, @NotNull UrlBuilder urlBuilder) {
        Intrinsics.checkNotNullParameter((Object)restrictionsService, (String)"restrictionsService");
        Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
        this.restrictionsService = restrictionsService;
        this.urlBuilder = urlBuilder;
        this.groupProfilePicturePath = "/images/icons/avatar_group_48.png";
    }

    @NotNull
    public final String getGroupProfilePicturePath() {
        return this.groupProfilePicturePath;
    }

    @GET
    @NotNull
    public final Response getRestrictions() {
        InstanceRestrictions restrictions = this.restrictionsService.getInstanceRestrictions();
        Response response = Response.ok(this.mapRestrictionsToDto(restrictions)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    @PUT
    @NotNull
    public final Response putRestrictions(@NotNull RestrictionsDto<NewInstanceUserGroupRestrictionDto> restrictions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(restrictions, (String)"restrictions");
        Iterable $this$map$iv = restrictions.getRestrictions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            NewInstanceUserGroupRestrictionDto newInstanceUserGroupRestrictionDto = (NewInstanceUserGroupRestrictionDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupRestriction(new Group(it.getGroupName()), it.getUseAnalytics()));
        }
        List list = (List)destination$iv$iv;
        InstanceRestrictions userGroupRestrictions = new InstanceRestrictions(list);
        InstanceRestrictions savedRestrictions = this.restrictionsService.saveInstanceRestrictions(userGroupRestrictions);
        Response response = Response.ok(this.mapRestrictionsToDto(savedRestrictions)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    /*
     * WARNING - void declaration
     */
    private final RestrictionsDto<InstanceUserGroupRestrictionDto> mapRestrictionsToDto(InstanceRestrictions restrictions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = restrictions.getUserGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupRestriction userGroupRestriction = (UserGroupRestriction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new InstanceUserGroupRestrictionDto(it.getGroup().getName(), this.urlBuilder.buildHostCanonicalUri(this.groupProfilePicturePath), it.getUseAnalytics()));
        }
        List list = (List)destination$iv$iv;
        return new RestrictionsDto<InstanceUserGroupRestrictionDto>(list);
    }
}

