/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest;

import com.addonengine.addons.analytics.rest.dto.settings.DataRetentionSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.EventLimitSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.NewDataRetentionSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.NewEventLimitSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.NewPrivacySettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.NewRateLimitSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.PrivacySettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.RateLimitSettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.SettingsDto;
import com.addonengine.addons.analytics.rest.dto.settings.TimeZoneDto;
import com.addonengine.addons.analytics.rest.filterbinding.UserIsAdmin;
import com.addonengine.addons.analytics.service.SettingsService;
import com.addonengine.addons.analytics.service.model.settings.DataRetentionSettings;
import com.addonengine.addons.analytics.service.model.settings.EventLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.NewDataRetentionSettings;
import com.addonengine.addons.analytics.service.model.settings.NewEventLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.NewPrivacySettings;
import com.addonengine.addons.analytics.service.model.settings.NewRateLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.PrivacySettings;
import com.addonengine.addons.analytics.service.model.settings.RateLimitSettings;
import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/settings")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ReadOnlyAccessAllowed
@UserIsAdmin
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0007H\u0007J\b\u0010\t\u001a\u00020\u0007H\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0007J!\u0010\u000f\u001a\u00020\u00072\n\b\u0003\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0017H\u0007J\b\u0010\u0018\u001a\u00020\u0007H\u0007J\u0012\u0010\u0019\u001a\u00020\u00072\b\b\u0001\u0010\u001a\u001a\u00020\u001bH\u0007J\b\u0010\u001c\u001a\u00020\u0007H\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\r\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010\r\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/addonengine/addons/analytics/rest/SettingsResource;", "", "settingsService", "Lcom/addonengine/addons/analytics/service/SettingsService;", "<init>", "(Lcom/addonengine/addons/analytics/service/SettingsService;)V", "getSettings", "Ljakarta/ws/rs/core/Response;", "getPrivacySetting", "getDataRetentionSetting", "getEventLimitSetting", "getRateLimitSetting", "putPrivacySetting", "settings", "Lcom/addonengine/addons/analytics/rest/dto/settings/NewPrivacySettingsDto;", "putDataRetentionSetting", "gracePeriod", "", "Lcom/addonengine/addons/analytics/rest/dto/settings/NewDataRetentionSettingsDto;", "(Ljava/lang/Integer;Lcom/addonengine/addons/analytics/rest/dto/settings/NewDataRetentionSettingsDto;)Ljakarta/ws/rs/core/Response;", "putEventLimitSetting", "Lcom/addonengine/addons/analytics/rest/dto/settings/NewEventLimitSettingsDto;", "putRateLimitSetting", "Lcom/addonengine/addons/analytics/rest/dto/settings/NewRateLimitSettingsDto;", "putDataRetentionSettingConfirmation", "deletePrivacySetting", "areYouSure", "", "serverTimezone", "mapPrivacySettings", "Lcom/addonengine/addons/analytics/rest/dto/settings/PrivacySettingsDto;", "Lcom/addonengine/addons/analytics/service/model/settings/PrivacySettings;", "mapDataRetentionSettings", "Lcom/addonengine/addons/analytics/rest/dto/settings/DataRetentionSettingsDto;", "Lcom/addonengine/addons/analytics/service/model/settings/DataRetentionSettings;", "mapDataLimitSettings", "Lcom/addonengine/addons/analytics/rest/dto/settings/EventLimitSettingsDto;", "Lcom/addonengine/addons/analytics/service/model/settings/EventLimitSettings;", "mapRateLimitSettings", "Lcom/addonengine/addons/analytics/rest/dto/settings/RateLimitSettingsDto;", "Lcom/addonengine/addons/analytics/service/model/settings/RateLimitSettings;", "analytics"})
public final class SettingsResource {
    @NotNull
    private final SettingsService settingsService;

    @Inject
    public SettingsResource(@NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.settingsService = settingsService;
    }

    @GET
    @NotNull
    public final Response getSettings() {
        PrivacySettings privacySettings = this.settingsService.getPrivacySettings();
        DataRetentionSettings dataRetentionSettings = this.settingsService.getDataRetentionSettings();
        EventLimitSettings eventLimitSettings = this.settingsService.getEventLimitSettings();
        RateLimitSettings rateLimitSettings = this.settingsService.getRateLimitSettings();
        Response response = Response.ok((Object)new SettingsDto(this.mapPrivacySettings(privacySettings), this.mapDataRetentionSettings(dataRetentionSettings), this.mapDataLimitSettings(eventLimitSettings), this.mapRateLimitSettings(rateLimitSettings))).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @GET
    @Path(value="/privacy")
    @NotNull
    public final Response getPrivacySetting() {
        PrivacySettings settings = this.settingsService.getPrivacySettings();
        Response response = Response.ok((Object)this.mapPrivacySettings(settings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @GET
    @Path(value="/dataRetention")
    @NotNull
    public final Response getDataRetentionSetting() {
        DataRetentionSettings settings = this.settingsService.getDataRetentionSettings();
        Response response = Response.ok((Object)this.mapDataRetentionSettings(settings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @GET
    @Path(value="/eventLimit")
    @NotNull
    public final Response getEventLimitSetting() {
        EventLimitSettings settings = this.settingsService.getEventLimitSettings();
        Response response = Response.ok((Object)this.mapDataLimitSettings(settings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @GET
    @Path(value="/rateLimit")
    @NotNull
    public final Response getRateLimitSetting() {
        RateLimitSettings settings = this.settingsService.getRateLimitSettings();
        Response response = Response.ok((Object)this.mapRateLimitSettings(settings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @PUT
    @Path(value="/privacy")
    @NotNull
    public final Response putPrivacySetting(@NotNull NewPrivacySettingsDto settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        PrivacySettings newSettings = this.settingsService.setPrivacySettings(new NewPrivacySettings(settings.getEnabled()));
        Response response = Response.ok((Object)this.mapPrivacySettings(newSettings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @PUT
    @Path(value="/dataRetention")
    @NotNull
    public final Response putDataRetentionSetting(@QueryParam(value="gracePeriod") @Nullable Integer gracePeriod, @NotNull NewDataRetentionSettingsDto settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        int n = settings.getMonths();
        DataRetentionSettings newSettings = this.settingsService.setDataRetentionSettings(new NewDataRetentionSettings(n, true), gracePeriod);
        Response response = Response.ok((Object)this.mapDataRetentionSettings(newSettings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    public static /* synthetic */ Response putDataRetentionSetting$default(SettingsResource settingsResource, Integer n, NewDataRetentionSettingsDto newDataRetentionSettingsDto, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = null;
        }
        return settingsResource.putDataRetentionSetting(n, newDataRetentionSettingsDto);
    }

    @PUT
    @Path(value="/eventLimit")
    @NotNull
    public final Response putEventLimitSetting(@NotNull NewEventLimitSettingsDto settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        EventLimitSettings newSettings = this.settingsService.setEventLimitSettings(new NewEventLimitSettings(settings.getMaxRowCount()));
        Response response = Response.ok((Object)this.mapDataLimitSettings(newSettings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @PUT
    @Path(value="/rateLimit")
    @NotNull
    public final Response putRateLimitSetting(@NotNull NewRateLimitSettingsDto settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        RateLimitSettings newSettings = this.settingsService.setRateLimitSettings(new NewRateLimitSettings(settings.getEnabled(), settings.getConcurrentSessions(), settings.getStaleOperationSeconds(), settings.getConcurrentOperationsPerSession()));
        Response response = Response.ok((Object)this.mapRateLimitSettings(newSettings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @PUT
    @Path(value="/dataRetention/confirm")
    @NotNull
    public final Response putDataRetentionSettingConfirmation() {
        DataRetentionSettings settings = this.settingsService.getDataRetentionSettings();
        int n = settings.getMonths();
        DataRetentionSettings newSettings = SettingsService.setDataRetentionSettings$default(this.settingsService, new NewDataRetentionSettings(n, true), null, 2, null);
        Response response = Response.ok((Object)this.mapDataRetentionSettings(newSettings)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    @DELETE
    @Path(value="/privacy")
    @NotNull
    public final Response deletePrivacySetting(@QueryParam(value="areYouSure") @NotNull String areYouSure) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)areYouSure, (String)"areYouSure");
        if (Intrinsics.areEqual((Object)areYouSure, (Object)"yes")) {
            this.settingsService.clearPrivacySettings();
            Response response2 = Response.ok().build();
            Intrinsics.checkNotNull((Object)response2);
            response = response2;
        } else {
            Response response3 = Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            Intrinsics.checkNotNull((Object)response3);
            response = response3;
        }
        return response;
    }

    @GET
    @Path(value="/timezone")
    @NotNull
    public final Response serverTimezone() {
        String string = this.settingsService.serverTimezone().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        Response response = Response.ok((Object)new TimeZoneDto(string)).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }

    private final PrivacySettingsDto mapPrivacySettings(PrivacySettings settings) {
        return new PrivacySettingsDto(settings.getEnabled());
    }

    private final DataRetentionSettingsDto mapDataRetentionSettings(DataRetentionSettings settings) {
        return new DataRetentionSettingsDto(settings.getMonths());
    }

    private final EventLimitSettingsDto mapDataLimitSettings(EventLimitSettings settings) {
        return new EventLimitSettingsDto(settings.getMaxRowCount() / (long)1000000);
    }

    private final RateLimitSettingsDto mapRateLimitSettings(RateLimitSettings settings) {
        return new RateLimitSettingsDto(settings.getEnabled(), settings.getConcurrentSessions(), settings.getStaleOperationSeconds(), settings.getConcurrentOperationsPerSession());
    }
}

