/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest.filter;

import com.addonengine.addons.analytics.rest.dto.ErrorDto;
import com.addonengine.addons.analytics.rest.dto.ErrorResponseDto;
import com.addonengine.addons.analytics.rest.filter.PrerequestFilter;
import com.addonengine.addons.analytics.rest.filterbinding.RateLimit;
import com.addonengine.addons.analytics.service.SettingsService;
import com.addonengine.addons.analytics.service.confluence.RateLimitService;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@RateLimit
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/addonengine/addons/analytics/rest/filter/RateLimitFilter;", "Lcom/addonengine/addons/analytics/rest/filter/PrerequestFilter;", "rateLimitService", "Lcom/addonengine/addons/analytics/service/confluence/RateLimitService;", "settingsService", "Lcom/addonengine/addons/analytics/service/SettingsService;", "<init>", "(Lcom/addonengine/addons/analytics/service/confluence/RateLimitService;Lcom/addonengine/addons/analytics/service/SettingsService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "filter", "", "requestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "responseContext", "Ljakarta/ws/rs/container/ContainerResponseContext;", "analytics"})
public final class RateLimitFilter
extends PrerequestFilter {
    @NotNull
    private final RateLimitService rateLimitService;
    @NotNull
    private final SettingsService settingsService;
    private final Logger log;

    public RateLimitFilter(@NotNull RateLimitService rateLimitService, @NotNull SettingsService settingsService) {
        Intrinsics.checkNotNullParameter((Object)rateLimitService, (String)"rateLimitService");
        Intrinsics.checkNotNullParameter((Object)settingsService, (String)"settingsService");
        this.rateLimitService = rateLimitService;
        this.settingsService = settingsService;
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        if (this.settingsService.getRateLimitSettings().getEnabled()) {
            String string = requestContext.getHeaderString("cookie");
            if (string == null) {
                string = "";
            }
            String sessionId = string;
            this.log.debug("Checking if rate limiting logic needs to be applied to session: [{}]", (Object)sessionId.hashCode());
            if (!StringsKt.isBlank((CharSequence)sessionId) && this.rateLimitService.rateLimit(sessionId)) {
                this.log.debug("Response will have been modified in RL handler. Stop here and return.");
                Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("RequestRateLimited", "There are too many users trying to open analytics at the same time. Try again in 1 minute from now.")));
                throw new WebApplicationException(response.build());
            }
        }
        this.log.debug("Request not blocked due to RL so continue on.");
    }

    @Override
    public void filter(@NotNull ContainerRequestContext requestContext, @NotNull ContainerResponseContext responseContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        Intrinsics.checkNotNullParameter((Object)responseContext, (String)"responseContext");
        if (this.settingsService.getRateLimitSettings().getEnabled()) {
            String string = requestContext.getHeaderString("cookie");
            if (string == null) {
                string = "";
            }
            String sessionId = string;
            this.log.debug("Decrementing the active operation count for session: [{}]", (Object)sessionId.hashCode());
            if (!StringsKt.isBlank((CharSequence)sessionId)) {
                this.rateLimitService.decrementOperationCount(sessionId);
            }
        }
    }
}

