/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest.filter;

import com.addonengine.addons.analytics.rest.dto.ErrorDto;
import com.addonengine.addons.analytics.rest.dto.ErrorResponseDto;
import com.addonengine.addons.analytics.rest.filter.PrerequestFilter;
import com.addonengine.addons.analytics.rest.filterbinding.UserHasPermissionToViewInstanceAnalytics;
import com.addonengine.addons.analytics.service.RestrictionsService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Provider
@UserHasPermissionToViewInstanceAnalytics
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/addonengine/addons/analytics/rest/filter/UserHasPermissionToViewInstanceAnalyticsFilter;", "Lcom/addonengine/addons/analytics/rest/filter/PrerequestFilter;", "restrictionsService", "Lcom/addonengine/addons/analytics/service/RestrictionsService;", "<init>", "(Lcom/addonengine/addons/analytics/service/RestrictionsService;)V", "filter", "", "requestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "analytics"})
public final class UserHasPermissionToViewInstanceAnalyticsFilter
extends PrerequestFilter {
    @NotNull
    private final RestrictionsService restrictionsService;

    public UserHasPermissionToViewInstanceAnalyticsFilter(@NotNull RestrictionsService restrictionsService) {
        Intrinsics.checkNotNullParameter((Object)restrictionsService, (String)"restrictionsService");
        this.restrictionsService = restrictionsService;
    }

    @Override
    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        String string = AuthenticatedUserThreadLocal.get().getKey().getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        String userKey = string;
        if (!this.restrictionsService.isUserAllowedToViewInstanceAnalytics(userKey)) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("ViewAnalyticsRestricted", "The requesting user does not have permission to view analytics.")));
            throw new WebApplicationException(response.build());
        }
    }
}

