/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest.filter;

import com.addonengine.addons.analytics.rest.dto.ErrorDto;
import com.addonengine.addons.analytics.rest.dto.ErrorResponseDto;
import com.addonengine.addons.analytics.rest.filter.PrerequestFilter;
import com.addonengine.addons.analytics.rest.filterbinding.UserIsSpaceAdmin;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import jakarta.inject.Named;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Provider
@UserIsSpaceAdmin
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/addonengine/addons/analytics/rest/filter/UserIsSpaceAdminFilter;", "Lcom/addonengine/addons/analytics/rest/filter/PrerequestFilter;", "permissionManager", "Lcom/atlassian/confluence/security/PermissionManager;", "spaceManager", "Lcom/atlassian/confluence/spaces/SpaceManager;", "<init>", "(Lcom/atlassian/confluence/security/PermissionManager;Lcom/atlassian/confluence/spaces/SpaceManager;)V", "filter", "", "requestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "buildBadRequestException", "Ljakarta/ws/rs/WebApplicationException;", "analytics"})
public final class UserIsSpaceAdminFilter
extends PrerequestFilter {
    @NotNull
    private final PermissionManager permissionManager;
    @NotNull
    private final SpaceManager spaceManager;

    public UserIsSpaceAdminFilter(@ComponentImport @NotNull PermissionManager permissionManager, @ComponentImport @NotNull SpaceManager spaceManager) {
        Intrinsics.checkNotNullParameter((Object)permissionManager, (String)"permissionManager");
        Intrinsics.checkNotNullParameter((Object)spaceManager, (String)"spaceManager");
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @Override
    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        String spaceKey = (String)requestContext.getUriInfo().getQueryParameters().getFirst((Object)"spaceKey");
        if (spaceKey == null) {
            throw this.buildBadRequestException();
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null || !this.permissionManager.hasPermission(user, Permission.ADMINISTER, (Object)space)) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("UserIsNotSpaceAdmin", "The requesting user must be a Space Admin of the '" + spaceKey + "' space.")));
            throw new WebApplicationException(response.build());
        }
    }

    private final WebApplicationException buildBadRequestException() {
        Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.BAD_REQUEST).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("MissingParameter", "Missing 'spaceKey' query string parameter.")));
        return new WebApplicationException(response.build());
    }
}

