/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest.filter;

import com.addonengine.addons.analytics.rest.dto.ErrorDto;
import com.addonengine.addons.analytics.rest.dto.ErrorResponseDto;
import com.addonengine.addons.analytics.rest.filter.PrerequestFilter;
import com.addonengine.addons.analytics.rest.filterbinding.UserIsSystemAdmin;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.Provider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Provider
@UserIsSystemAdmin
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/addonengine/addons/analytics/rest/filter/UserIsSystemAdminFilter;", "Lcom/addonengine/addons/analytics/rest/filter/PrerequestFilter;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "<init>", "(Lcom/atlassian/sal/api/user/UserManager;)V", "filter", "", "requestContext", "Ljakarta/ws/rs/container/ContainerRequestContext;", "analytics"})
public final class UserIsSystemAdminFilter
extends PrerequestFilter {
    @NotNull
    private final UserManager userManager;

    public UserIsSystemAdminFilter(@ComponentImport @NotNull UserManager userManager) {
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        this.userManager = userManager;
    }

    @Override
    public void filter(@NotNull ContainerRequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        if (!this.userManager.isSystemAdmin(this.userManager.getRemoteUserKey())) {
            Response.ResponseBuilder response = Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/json").entity((Object)new ErrorResponseDto(new ErrorDto("UserIsNotSystemAdmin", "The requesting user must be a Confluence system administrator.")));
            throw new WebApplicationException(response.build());
        }
    }
}

