/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.rest.util.excel;

import com.addonengine.addons.analytics.service.confluence.UrlBuilder;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.net.URI;
import java.net.URL;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0000H\u0016R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/addonengine/addons/analytics/rest/util/excel/ExcelGenerationException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Ljakarta/ws/rs/ext/ExceptionMapper;", "<init>", "()V", "cause", "", "(Ljava/lang/Throwable;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "urlBuilder", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "getUrlBuilder", "()Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "setUrlBuilder", "(Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;)V", "toResponse", "Ljakarta/ws/rs/core/Response;", "exception", "analytics"})
public final class ExcelGenerationException
extends Exception
implements ExceptionMapper<ExcelGenerationException> {
    private final Logger log;
    @Inject
    public UrlBuilder urlBuilder;

    public ExcelGenerationException() {
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    public ExcelGenerationException(@NotNull Throwable cause) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        super(cause);
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final UrlBuilder getUrlBuilder() {
        UrlBuilder urlBuilder = this.urlBuilder;
        if (urlBuilder != null) {
            return urlBuilder;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"urlBuilder");
        return null;
    }

    public final void setUrlBuilder(@NotNull UrlBuilder urlBuilder) {
        Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"<set-?>");
        this.urlBuilder = urlBuilder;
    }

    @NotNull
    public Response toResponse(@NotNull ExcelGenerationException exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.log.error(exception.toString(), (Throwable)exception);
        URL url = this.getUrlBuilder().buildHostActionUrl("servererror");
        Response response = Response.temporaryRedirect((URI)url.toURI()).build();
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"build(...)");
        return response;
    }
}

