/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service;

import com.addonengine.addons.analytics.service.AddonService;
import com.addonengine.addons.analytics.service.model.AddonDetails;
import com.addonengine.addons.analytics.service.model.SampleDataDetails;
import com.addonengine.addons.analytics.store.EventRepository;
import com.addonengine.addons.analytics.store.SampleEventRepository;
import com.addonengine.addons.analytics.store.model.SampleDataMetadata;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J!\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/addonengine/addons/analytics/service/AddonServiceImpl;", "Lcom/addonengine/addons/analytics/service/AddonService;", "eventRepository", "Lcom/addonengine/addons/analytics/store/EventRepository;", "sampleEventRepository", "Lcom/addonengine/addons/analytics/store/SampleEventRepository;", "<init>", "(Lcom/addonengine/addons/analytics/store/EventRepository;Lcom/addonengine/addons/analytics/store/SampleEventRepository;)V", "getDetails", "Lcom/addonengine/addons/analytics/service/model/AddonDetails;", "buildSampleData", "Lcom/addonengine/addons/analytics/service/model/SampleDataDetails;", "fromTime", "", "toTime", "(Ljava/lang/Long;Ljava/lang/Long;)Lcom/addonengine/addons/analytics/service/model/SampleDataDetails;", "convertSampleDataMetadata", "sampleDataMetadata", "Lcom/addonengine/addons/analytics/store/model/SampleDataMetadata;", "analytics"})
public final class AddonServiceImpl
implements AddonService {
    @NotNull
    private final EventRepository eventRepository;
    @NotNull
    private final SampleEventRepository sampleEventRepository;

    @Autowired
    public AddonServiceImpl(@NotNull EventRepository eventRepository, @NotNull SampleEventRepository sampleEventRepository) {
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        Intrinsics.checkNotNullParameter((Object)sampleEventRepository, (String)"sampleEventRepository");
        this.eventRepository = eventRepository;
        this.sampleEventRepository = sampleEventRepository;
    }

    @Override
    @NotNull
    public AddonDetails getDetails() {
        Instant instant = this.eventRepository.getFirstEventDate();
        if (instant == null) {
            instant = Instant.now();
        }
        Instant firstEventAt = instant;
        SampleDataDetails sampleDataDetails = this.convertSampleDataMetadata(this.sampleEventRepository.getSampleDataMetadata());
        Intrinsics.checkNotNull((Object)firstEventAt);
        return new AddonDetails(firstEventAt, sampleDataDetails);
    }

    @Override
    @NotNull
    public SampleDataDetails buildSampleData(@Nullable Long fromTime, @Nullable Long toTime) {
        SampleDataDetails sampleDataDetails = this.convertSampleDataMetadata(this.sampleEventRepository.buildSampleEventStore(fromTime, toTime));
        Intrinsics.checkNotNull((Object)sampleDataDetails);
        return sampleDataDetails;
    }

    private final SampleDataDetails convertSampleDataMetadata(SampleDataMetadata sampleDataMetadata) {
        SampleDataDetails sampleDataDetails;
        SampleDataMetadata sampleDataMetadata2 = sampleDataMetadata;
        if (sampleDataMetadata2 != null) {
            SampleDataMetadata it = sampleDataMetadata2;
            boolean bl = false;
            sampleDataDetails = new SampleDataDetails(it.getMinDate(), it.getMaxDate(), it.getLastUpdatedAt());
        } else {
            sampleDataDetails = null;
        }
        return sampleDataDetails;
    }
}

