/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service;

import com.addonengine.addons.analytics.service.HashService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import jakarta.inject.Named;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;

@ExportAsDevService(value={HashService.class})
@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/addonengine/addons/analytics/service/HashServiceImpl;", "Lcom/addonengine/addons/analytics/service/HashService;", "<init>", "()V", "appSalt", "", "saltSizeBytes", "", "hashString", "data", "instanceSalt", "generateInstanceSalt", "analytics"})
public final class HashServiceImpl
implements HashService {
    @NotNull
    private final String appSalt;
    private final int saltSizeBytes;

    public HashServiceImpl() {
        this.appSalt = "GhkwaoBY)1tsRRqGc.nTAMtlj5VFNNTqvPTDfo";
        this.saltSizeBytes = 32;
    }

    @Override
    @NotNull
    public String hashString(@NotNull String data, @NotNull String instanceSalt) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)instanceSalt, (String)"instanceSalt");
        String saltedValue = data + "-" + this.appSalt + "-" + instanceSalt;
        String string = DigestUtils.sha1Hex((String)saltedValue);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sha1Hex(...)");
        return string;
    }

    @Override
    @NotNull
    public String generateInstanceSalt() {
        SecureRandom sr = SecureRandom.getInstance("SHA1PRNG");
        byte[] salt = new byte[this.saltSizeBytes];
        sr.nextBytes(salt);
        String string = Base64.encodeBase64String((byte[])salt);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64String(...)");
        return string;
    }
}

