/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service;

import com.addonengine.addons.analytics.service.InstancePaginatedAnalyticsService;
import com.addonengine.addons.analytics.service.UtilsKt;
import com.addonengine.addons.analytics.service.confluence.SpaceService;
import com.addonengine.addons.analytics.service.confluence.UserService;
import com.addonengine.addons.analytics.service.confluence.model.Space;
import com.addonengine.addons.analytics.service.model.AnalyticsEvent;
import com.addonengine.addons.analytics.service.model.ContentType;
import com.addonengine.addons.analytics.service.model.CountType;
import com.addonengine.addons.analytics.service.model.DatePeriodOptions;
import com.addonengine.addons.analytics.service.model.GlobalUserActivity;
import com.addonengine.addons.analytics.service.model.GlobalUserSortField;
import com.addonengine.addons.analytics.service.model.LazyFetching;
import com.addonengine.addons.analytics.service.model.SortOrder;
import com.addonengine.addons.analytics.service.model.SpaceActivity;
import com.addonengine.addons.analytics.service.model.SpaceSortField;
import com.addonengine.addons.analytics.service.model.SpaceType;
import com.addonengine.addons.analytics.store.EventRepository;
import com.addonengine.addons.analytics.store.model.FullGlobalUserStatistics;
import com.addonengine.addons.analytics.store.model.FullSpaceStatistics;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

@ConfluenceComponent
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 '2\u00020\u0001:\u0001'B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJj\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0015\u0010 \u001a\u0004\u0018\u00010!*\u0004\u0018\u00010\"H\u0002\u00a2\u0006\u0002\u0010#JT\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/addonengine/addons/analytics/service/InstancePaginatedAnalyticsServiceImpl;", "Lcom/addonengine/addons/analytics/service/InstancePaginatedAnalyticsService;", "spaceService", "Lcom/addonengine/addons/analytics/service/confluence/SpaceService;", "eventRepository", "Lcom/addonengine/addons/analytics/store/EventRepository;", "userService", "Lcom/addonengine/addons/analytics/service/confluence/UserService;", "<init>", "(Lcom/addonengine/addons/analytics/service/confluence/SpaceService;Lcom/addonengine/addons/analytics/store/EventRepository;Lcom/addonengine/addons/analytics/service/confluence/UserService;)V", "getActivityBySpace", "", "Lcom/addonengine/addons/analytics/service/model/SpaceActivity;", "datePeriodOptions", "Lcom/addonengine/addons/analytics/service/model/DatePeriodOptions;", "spaceTypes", "", "Lcom/addonengine/addons/analytics/service/model/SpaceType;", "contentTypes", "Lcom/addonengine/addons/analytics/service/model/ContentType;", "pageToken", "", "limit", "", "sortField", "Lcom/addonengine/addons/analytics/service/model/SpaceSortField;", "sortOrder", "Lcom/addonengine/addons/analytics/service/model/SortOrder;", "countType", "Lcom/addonengine/addons/analytics/service/model/CountType;", "includeSpaceCategories", "", "toTimestamp", "Ljava/time/Instant;", "", "(Ljava/lang/Long;)Ljava/time/Instant;", "getActivityByUser", "Lcom/addonengine/addons/analytics/service/model/GlobalUserActivity;", "Lcom/addonengine/addons/analytics/service/model/GlobalUserSortField;", "Companion", "analytics"})
@SourceDebugExtension(value={"SMAP\nInstancePaginatedAnalyticsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InstancePaginatedAnalyticsServiceImpl.kt\ncom/addonengine/addons/analytics/service/InstancePaginatedAnalyticsServiceImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,156:1\n1#2:157\n*E\n"})
public final class InstancePaginatedAnalyticsServiceImpl
implements InstancePaginatedAnalyticsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpaceService spaceService;
    @NotNull
    private final EventRepository eventRepository;
    @NotNull
    private final UserService userService;
    private static final Integer firstBatchSize = Integer.getInteger("confluence.analytics.pagination.first.batch.size", 500);
    private static final Integer subsequentBatchSize = Integer.getInteger("confluence.analytics.pagination.subsequent.batch.size", 25000);

    @Autowired
    public InstancePaginatedAnalyticsServiceImpl(@NotNull SpaceService spaceService, @NotNull EventRepository eventRepository, @NotNull UserService userService) {
        Intrinsics.checkNotNullParameter((Object)spaceService, (String)"spaceService");
        Intrinsics.checkNotNullParameter((Object)eventRepository, (String)"eventRepository");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        this.spaceService = spaceService;
        this.eventRepository = eventRepository;
        this.userService = userService;
    }

    @Override
    @NotNull
    public List<SpaceActivity> getActivityBySpace(@NotNull DatePeriodOptions datePeriodOptions, @NotNull Set<? extends SpaceType> spaceTypes, @NotNull Set<? extends ContentType> contentTypes, @Nullable String pageToken, int limit, @NotNull SpaceSortField sortField, @NotNull SortOrder sortOrder, @NotNull Set<? extends CountType> countType, boolean includeSpaceCategories) {
        Intrinsics.checkNotNullParameter((Object)datePeriodOptions, (String)"datePeriodOptions");
        Intrinsics.checkNotNullParameter(spaceTypes, (String)"spaceTypes");
        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)sortField), (String)"sortField");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Intrinsics.checkNotNullParameter(countType, (String)"countType");
        Long l = this.eventRepository.getMaximumEventId();
        long maxEventId = l != null ? l : 0L;
        Integer n = firstBatchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"firstBatchSize");
        int n2 = ((Number)n).intValue();
        Integer n3 = subsequentBatchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"subsequentBatchSize");
        Sequence allSpacesStatistics = LazyFetching.Companion.numerical(n2, ((Number)n3).intValue(), (arg_0, arg_1) -> InstancePaginatedAnalyticsServiceImpl.getActivityBySpace$lambda$0(this, contentTypes, datePeriodOptions, spaceTypes, sortField, sortOrder, maxEventId, countType, arg_0, arg_1)).asSequence();
        CharSequence charSequence = pageToken;
        Sequence currentPageCandidates = charSequence == null || charSequence.length() == 0 ? allSpacesStatistics : SequencesKt.drop((Sequence)SequencesKt.dropWhile(allSpacesStatistics, arg_0 -> InstancePaginatedAnalyticsServiceImpl.getActivityBySpace$lambda$1(pageToken, arg_0)), (int)1);
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)currentPageCandidates, arg_0 -> InstancePaginatedAnalyticsServiceImpl.getActivityBySpace$lambda$2(this, includeSpaceCategories, arg_0)), InstancePaginatedAnalyticsServiceImpl::getActivityBySpace$lambda$3), arg_0 -> InstancePaginatedAnalyticsServiceImpl.getActivityBySpace$lambda$4(this, arg_0)), (int)limit));
    }

    private final Instant toTimestamp(Long $this$toTimestamp) {
        Instant instant;
        Long l = $this$toTimestamp;
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl = false;
            instant = Instant.ofEpochMilli($this$toTimestamp);
        } else {
            instant = null;
        }
        return instant;
    }

    @Override
    @NotNull
    public List<GlobalUserActivity> getActivityByUser(@NotNull DatePeriodOptions datePeriodOptions, @NotNull Set<? extends SpaceType> spaceTypes, @NotNull Set<? extends ContentType> contentTypes, @Nullable String pageToken, int limit, @NotNull GlobalUserSortField sortField, @NotNull SortOrder sortOrder) {
        Sequence eventsByUser;
        Intrinsics.checkNotNullParameter((Object)datePeriodOptions, (String)"datePeriodOptions");
        Intrinsics.checkNotNullParameter(spaceTypes, (String)"spaceTypes");
        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
        Intrinsics.checkNotNullParameter((Object)((Object)sortField), (String)"sortField");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOrder), (String)"sortOrder");
        Long l = this.eventRepository.getMaximumEventId();
        if (l == null) {
            return CollectionsKt.emptyList();
        }
        long maxEventId = l;
        List<AnalyticsEvent> viewEvents = UtilsKt.contentTypesToEvents(contentTypes, AnalyticsEvent.PAGE_VIEWED, AnalyticsEvent.BLOG_VIEWED);
        List<AnalyticsEvent> createEvents = UtilsKt.contentTypesToEvents(contentTypes, AnalyticsEvent.PAGE_CREATED, AnalyticsEvent.BLOG_CREATED);
        List<AnalyticsEvent> updateEvents = UtilsKt.contentTypesToEvents(contentTypes, AnalyticsEvent.PAGE_UPDATED, AnalyticsEvent.BLOG_UPDATED);
        List commentEvents = CollectionsKt.listOf((Object)((Object)AnalyticsEvent.COMMENT_CREATED));
        List contributorEvents = CollectionsKt.toList((Iterable)CollectionsKt.union((Iterable)CollectionsKt.union((Iterable)createEvents, (Iterable)updateEvents), (Iterable)commentEvents));
        Integer n = firstBatchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"firstBatchSize");
        int n2 = ((Number)n).intValue();
        Integer n3 = subsequentBatchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"subsequentBatchSize");
        Sequence seq = eventsByUser = LazyFetching.Companion.numerical(n2, ((Number)n3).intValue(), (arg_0, arg_1) -> InstancePaginatedAnalyticsServiceImpl.getActivityByUser$lambda$6(this, viewEvents, createEvents, updateEvents, commentEvents, contributorEvents, datePeriodOptions, spaceTypes, sortField, sortOrder, maxEventId, arg_0, arg_1)).asSequence();
        boolean bl = false;
        CharSequence charSequence = pageToken;
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map(charSequence == null || charSequence.length() == 0 ? seq : SequencesKt.drop((Sequence)SequencesKt.dropWhile(seq, arg_0 -> InstancePaginatedAnalyticsServiceImpl.getActivityByUser$lambda$8$lambda$7(pageToken, arg_0)), (int)1), arg_0 -> InstancePaginatedAnalyticsServiceImpl.getActivityByUser$lambda$9(this, arg_0)), (int)limit));
    }

    private static final List getActivityBySpace$lambda$0(InstancePaginatedAnalyticsServiceImpl this$0, Set $contentTypes, DatePeriodOptions $datePeriodOptions, Set $spaceTypes, SpaceSortField $sortField, SortOrder $sortOrder, long $maxEventId, Set $countType, int offset, int batchLimit) {
        return this$0.eventRepository.getEventsForAllSpaces(UtilsKt.contentTypesToEvents((Set<? extends ContentType>)$contentTypes, AnalyticsEvent.PAGE_VIEWED, AnalyticsEvent.BLOG_VIEWED), UtilsKt.contentTypesToEvents((Set<? extends ContentType>)$contentTypes, AnalyticsEvent.PAGE_CREATED, AnalyticsEvent.BLOG_CREATED), UtilsKt.contentTypesToEvents((Set<? extends ContentType>)$contentTypes, AnalyticsEvent.PAGE_UPDATED, AnalyticsEvent.BLOG_UPDATED), $datePeriodOptions, $spaceTypes, $sortField, $sortOrder, $maxEventId, offset, batchLimit, $countType);
    }

    private static final boolean getActivityBySpace$lambda$1(String $pageToken, FullSpaceStatistics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getSpaceKey(), (Object)$pageToken);
    }

    private static final Pair getActivityBySpace$lambda$2(InstancePaginatedAnalyticsServiceImpl this$0, boolean $includeSpaceCategories, FullSpaceStatistics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair((Object)it, (Object)this$0.spaceService.getByKeyOrNull(it.getSpaceKey(), $includeSpaceCategories));
    }

    private static final boolean getActivityBySpace$lambda$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSecond() != null;
    }

    private static final SpaceActivity getActivityBySpace$lambda$4(InstancePaginatedAnalyticsServiceImpl this$0, Pair it) {
        Space spaceObject;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        FullSpaceStatistics spaceStats = (FullSpaceStatistics)it.getFirst();
        Space space = spaceObject = (Space)it.getSecond();
        Intrinsics.checkNotNull((Object)space);
        Space space2 = space;
        Long l = spaceStats.getViewCount();
        long l2 = spaceStats.getCreateCount();
        long l3 = spaceStats.getUpdateCount();
        Long l4 = spaceStats.getUsersViewed();
        Instant instant = this$0.toTimestamp(spaceStats.getLastEventAt());
        return new SpaceActivity(space2, l2, l3, instant, l4, l);
    }

    private static final List getActivityByUser$lambda$6(InstancePaginatedAnalyticsServiceImpl this$0, List $viewEvents, List $createEvents, List $updateEvents, List $commentEvents, List $contributorEvents, DatePeriodOptions $datePeriodOptions, Set $spaceTypes, GlobalUserSortField $sortField, SortOrder $sortOrder, long $maxEventId, int offset, int batchLimit) {
        return this$0.eventRepository.getEventsForGlobalUsers($viewEvents, $createEvents, $updateEvents, $commentEvents, $contributorEvents, $datePeriodOptions, $spaceTypes, $sortField, $sortOrder, $maxEventId, offset, batchLimit);
    }

    private static final boolean getActivityByUser$lambda$8$lambda$7(String $pageToken, FullGlobalUserStatistics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)$pageToken, (Object)it.getUserKey());
    }

    private static final GlobalUserActivity getActivityByUser$lambda$9(InstancePaginatedAnalyticsServiceImpl this$0, FullGlobalUserStatistics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new GlobalUserActivity(it.getUserKey(), this$0.userService.getUserType(it.getUserKey()), it.getViewedCount(), it.getCreatedCount(), it.getUpdatedCount(), it.getCommentsCount(), it.getContributorScore());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0018\u0010\b\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Lcom/addonengine/addons/analytics/service/InstancePaginatedAnalyticsServiceImpl$Companion;", "", "<init>", "()V", "firstBatchSize", "", "kotlin.jvm.PlatformType", "Ljava/lang/Integer;", "subsequentBatchSize", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

