/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service;

import com.addonengine.addons.analytics.service.RestrictionsService;
import com.addonengine.addons.analytics.service.confluence.ConfluenceInfoService;
import com.addonengine.addons.analytics.service.confluence.ContentService;
import com.addonengine.addons.analytics.service.confluence.GroupService;
import com.addonengine.addons.analytics.service.confluence.UserService;
import com.addonengine.addons.analytics.service.confluence.model.Group;
import com.addonengine.addons.analytics.service.confluence.model.User;
import com.addonengine.addons.analytics.service.model.restrictions.InstanceRestrictions;
import com.addonengine.addons.analytics.service.model.restrictions.SpaceRestrictions;
import com.addonengine.addons.analytics.service.model.restrictions.UserGroupRestriction;
import com.addonengine.addons.analytics.service.model.restrictions.UserRestriction;
import com.addonengine.addons.analytics.store.RestrictionsRepository;
import com.addonengine.addons.analytics.store.model.InstanceRestrictionsData;
import com.addonengine.addons.analytics.store.model.SpaceRestrictionsData;
import com.addonengine.addons.analytics.store.model.UserGroupRestrictionData;
import com.addonengine.addons.analytics.store.model.UserRestrictionData;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.event.group.GroupMembershipDeletedEvent;
import com.atlassian.crowd.event.group.GroupMembershipsCreatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.util.profiling.UtilTimerStack;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003BE\b\u0007\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0018H\u0016J\u0018\u0010\"\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0018\u0010$\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020(2\u0006\u0010,\u001a\u00020(H\u0016J,\u0010-\u001a\u00020*2\u0006\u0010#\u001a\u00020\u00182\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00180/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00180/H\u0016J\u0010\u00101\u001a\u00020\u001f2\u0006\u00102\u001a\u000203H\u0007J\u0010\u00104\u001a\u00020\u001f2\u0006\u00102\u001a\u000205H\u0007J&\u00106\u001a\u00020*2\u0006\u0010,\u001a\u0002072\u0014\u00108\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0012\u0004\u0012\u00020:09H\u0002J\u0010\u0010;\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0018H\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0002J$\u0010=\u001a\u00020\u00192\f\u00100\u001a\b\u0012\u0004\u0012\u00020>0/2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@0/H\u0002J\u0014\u0010A\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002J\u0014\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017H\u0002J\b\u0010C\u001a\u00020\u001fH\u0002J\u0010\u0010D\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\u0018H\u0002J\b\u0010F\u001a\u00020\u001fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00190\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/addonengine/addons/analytics/service/RestrictionsServiceImpl;", "Lcom/addonengine/addons/analytics/service/RestrictionsService;", "Lorg/springframework/beans/factory/InitializingBean;", "Lorg/springframework/beans/factory/DisposableBean;", "eventPublisher", "Lcom/atlassian/event/api/EventPublisher;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "confluenceInfoService", "Lcom/addonengine/addons/analytics/service/confluence/ConfluenceInfoService;", "restrictionsRepository", "Lcom/addonengine/addons/analytics/store/RestrictionsRepository;", "groupService", "Lcom/addonengine/addons/analytics/service/confluence/GroupService;", "userService", "Lcom/addonengine/addons/analytics/service/confluence/UserService;", "contentService", "Lcom/addonengine/addons/analytics/service/confluence/ContentService;", "<init>", "(Lcom/atlassian/event/api/EventPublisher;Lcom/atlassian/cache/CacheManager;Lcom/addonengine/addons/analytics/service/confluence/ConfluenceInfoService;Lcom/addonengine/addons/analytics/store/RestrictionsRepository;Lcom/addonengine/addons/analytics/service/confluence/GroupService;Lcom/addonengine/addons/analytics/service/confluence/UserService;Lcom/addonengine/addons/analytics/service/confluence/ContentService;)V", "getEventPublisher", "()Lcom/atlassian/event/api/EventPublisher;", "instanceRestrictionsCache", "Lcom/atlassian/cache/Cache;", "", "", "spaceRestrictionsCache", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "afterPropertiesSet", "", "isUserAllowedToViewInstanceAnalytics", "userKey", "isUserAllowedToViewSpaceAnalytics", "spaceKey", "isUserAllowedToViewContentAnalytics", "contentId", "", "getInstanceRestrictions", "Lcom/addonengine/addons/analytics/service/model/restrictions/InstanceRestrictions;", "getSpaceRestrictions", "Lcom/addonengine/addons/analytics/service/model/restrictions/SpaceRestrictions;", "saveInstanceRestrictions", "restrictions", "saveSpaceRestrictions", "userRestrictions", "", "userGroupRestrictions", "onGroupMembershipsCreatedEvent", "event", "Lcom/atlassian/crowd/event/group/GroupMembershipsCreatedEvent;", "onGroupMembershipDeletedEvent", "Lcom/atlassian/crowd/event/group/GroupMembershipDeletedEvent;", "mapDataToSpaceRestrictions", "Lcom/addonengine/addons/analytics/store/model/SpaceRestrictionsData;", "users", "", "Lcom/addonengine/addons/analytics/service/confluence/model/User;", "isUserAllowedToViewInstanceAnalyticsInternal", "isUserAllowedToViewSpaceAnalyticsInternal", "isUserMemberOfAllowedGroups", "Lcom/addonengine/addons/analytics/store/model/UserGroupRestrictionData;", "groupsUserIsIn", "Lcom/addonengine/addons/analytics/service/confluence/model/Group;", "buildInstanceCache", "buildSpacesCache", "clearCaches", "clearUserFromCacheByUsername", "userName", "destroy", "analytics"})
@SourceDebugExtension(value={"SMAP\nRestrictionsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestrictionsServiceImpl.kt\ncom/addonengine/addons/analytics/service/RestrictionsServiceImpl\n+ 2 utils.kt\ncom/addonengine/addons/analytics/util/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,261:1\n11#2,11:262\n11#2,11:273\n1208#3,2:284\n1236#3,4:286\n1563#3:290\n1634#3,3:291\n1634#3,3:305\n1208#3,2:308\n1236#3,4:310\n1563#3:314\n1634#3,3:315\n1563#3:318\n1634#3,3:319\n1563#3:322\n1634#3,3:323\n1563#3:326\n1634#3,3:327\n1208#3,2:330\n1236#3,4:332\n1869#3,2:336\n1563#3:338\n1634#3,3:339\n1563#3:342\n1634#3,3:343\n1761#3,3:346\n774#3:349\n865#3,2:350\n1563#3:352\n1634#3,3:353\n1563#3:356\n1634#3,3:357\n536#4:294\n521#4,6:295\n126#5:301\n153#5,3:302\n*S KotlinDebug\n*F\n+ 1 RestrictionsServiceImpl.kt\ncom/addonengine/addons/analytics/service/RestrictionsServiceImpl\n*L\n53#1:262,11\n59#1:273,11\n72#1:284,2\n72#1:286,4\n73#1:290\n73#1:291,3\n85#1:305,3\n86#1:308,2\n86#1:310,4\n92#1:314\n92#1:315,3\n99#1:318\n99#1:319,3\n108#1:322\n108#1:323,3\n109#1:326\n109#1:327,3\n112#1:330,2\n112#1:332,4\n129#1:336,2\n139#1:338\n139#1:339,3\n142#1:342\n142#1:343,3\n180#1:346,3\n189#1:349\n189#1:350,2\n189#1:352\n189#1:353,3\n190#1:356\n190#1:357,3\n77#1:294\n77#1:295,6\n78#1:301\n78#1:302,3\n*E\n"})
public final class RestrictionsServiceImpl
implements RestrictionsService,
InitializingBean,
DisposableBean {
    @NotNull
    private final EventPublisher eventPublisher;
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final ConfluenceInfoService confluenceInfoService;
    @NotNull
    private final RestrictionsRepository restrictionsRepository;
    @NotNull
    private final GroupService groupService;
    @NotNull
    private final UserService userService;
    @NotNull
    private final ContentService contentService;
    @NotNull
    private final Cache<String, Boolean> instanceRestrictionsCache;
    @NotNull
    private final Cache<String, Boolean> spaceRestrictionsCache;
    private final Logger log;

    @Inject
    public RestrictionsServiceImpl(@ComponentImport @NotNull EventPublisher eventPublisher, @ComponentImport @NotNull CacheManager cacheManager, @NotNull ConfluenceInfoService confluenceInfoService, @NotNull RestrictionsRepository restrictionsRepository, @NotNull GroupService groupService, @NotNull UserService userService, @NotNull ContentService contentService) {
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)confluenceInfoService, (String)"confluenceInfoService");
        Intrinsics.checkNotNullParameter((Object)restrictionsRepository, (String)"restrictionsRepository");
        Intrinsics.checkNotNullParameter((Object)groupService, (String)"groupService");
        Intrinsics.checkNotNullParameter((Object)userService, (String)"userService");
        Intrinsics.checkNotNullParameter((Object)contentService, (String)"contentService");
        this.eventPublisher = eventPublisher;
        this.cacheManager = cacheManager;
        this.confluenceInfoService = confluenceInfoService;
        this.restrictionsRepository = restrictionsRepository;
        this.groupService = groupService;
        this.userService = userService;
        this.contentService = contentService;
        this.instanceRestrictionsCache = this.buildInstanceCache();
        this.spaceRestrictionsCache = this.buildSpacesCache();
        this.log = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isUserAllowedToViewInstanceAnalytics(@NotNull String userKey) {
        void klass$iv;
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "isUserAllowedToViewAnalytics_InstanceCheck";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Boolean result$iv = (Boolean)this.instanceRestrictionsCache.get((Object)userKey, () -> RestrictionsServiceImpl.isUserAllowedToViewInstanceAnalytics$lambda$1$lambda$0(this, userKey));
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        Boolean bl2 = result$iv;
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"atlassianProfilingTimer(...)");
        return bl2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isUserAllowedToViewSpaceAnalytics(@NotNull String userKey, @NotNull String spaceKey) {
        void klass$iv;
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        Intrinsics.checkNotNullParameter((Object)spaceKey, (String)"spaceKey");
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "isUserAllowedToViewAnalytics_SpaceCheck";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Boolean result$iv = (Boolean)this.spaceRestrictionsCache.get((Object)(userKey + "|" + spaceKey), () -> RestrictionsServiceImpl.isUserAllowedToViewSpaceAnalytics$lambda$3$lambda$2(this, userKey, spaceKey));
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        Boolean bl2 = result$iv;
        Intrinsics.checkNotNullExpressionValue((Object)bl2, (String)"atlassianProfilingTimer(...)");
        return bl2;
    }

    @Override
    public boolean isUserAllowedToViewContentAnalytics(@NotNull String userKey, long contentId) {
        Intrinsics.checkNotNullParameter((Object)userKey, (String)"userKey");
        String spaceKey = this.contentService.getById(contentId).getSpace().getKey();
        return this.isUserAllowedToViewSpaceAnalytics(userKey, spaceKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InstanceRestrictions getInstanceRestrictions() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry it;
        void $this$filterTo$iv$iv;
        Map $this$filter$iv;
        Map $this$mapTo$iv$iv2;
        UserGroupRestrictionData it2;
        Object object;
        Iterator iterator;
        Iterable $this$associateByTo$iv$iv;
        List<UserGroupRestrictionData> restrictions = this.restrictionsRepository.getInstanceRestrictions().getUserGroups();
        Iterable $this$associateBy$iv = restrictions;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            iterator = (UserGroupRestrictionData)element$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.put(new Group(it2.getGroupName()), element$iv$iv);
        }
        Map groupsWithSettings = destination$iv$iv;
        Iterable $this$map$iv2 = restrictions;
        boolean $i$f$map = false;
        $this$associateByTo$iv$iv = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv = iterator2.next();
            it2 = (UserGroupRestrictionData)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it2.getGroupName());
        }
        List groupNames = (List)destination$iv$iv;
        List<String> groupsInConfluence = this.groupService.getGroupNamesInConfluence(groupNames);
        $this$mapTo$iv$iv2 = groupsWithSettings;
        boolean $i$f$filter = false;
        void $i$f$mapTo22 = $this$filter$iv;
        Object destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!groupsInConfluence.contains(((UserGroupRestrictionData)it.getValue()).getGroupName())) continue;
            destination$iv$iv2.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv2;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            it = item$iv$iv = iterator.next();
            object = destination$iv$iv2;
            boolean bl = false;
            object.add(new UserGroupRestriction((Group)it.getKey(), ((UserGroupRestrictionData)it.getValue()).getUseAnalytics()));
        }
        List existingGroupRestrictions = (List)destination$iv$iv2;
        return new InstanceRestrictions(existingGroupRestrictions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpaceRestrictions getSpaceRestrictions(@NotNull String spaceKey) {
        void $this$associateByTo$iv$iv;
        Map map;
        void destination$iv;
        Object item$iv2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)spaceKey, (String)"spaceKey");
        SpaceRestrictionsData restrictions = this.restrictionsRepository.getSpaceRestrictions(spaceKey);
        Iterable iterable = restrictions.getUsers();
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv2 : $this$mapTo$iv) {
            void it;
            UserRestrictionData userRestrictionData = (UserRestrictionData)item$iv2;
            map = destination$iv;
            boolean bl = false;
            map.add(it.getUserKey());
        }
        Set userKeys = (Set)destination$iv;
        Iterable $this$associateBy$iv = this.userService.getUserDetails(userKeys, true);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        item$iv2 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            User user = (User)element$iv$iv;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getUserKey(), element$iv$iv);
        }
        Map users = destination$iv$iv;
        return this.mapDataToSpaceRestrictions(restrictions, users);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public InstanceRestrictions saveInstanceRestrictions(@NotNull InstanceRestrictions restrictions) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)restrictions, (String)"restrictions");
        Iterable $this$map$iv = restrictions.getUserGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            UserGroupRestriction userGroupRestriction = (UserGroupRestriction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupRestrictionData(it.getGroup().getName(), it.getUseAnalytics()));
        }
        List list = (List)destination$iv$iv;
        InstanceRestrictionsData restrictionsData = new InstanceRestrictionsData(list);
        InstanceRestrictionsData savedRestrictionsData = this.restrictionsRepository.saveInstanceRestrictions(restrictionsData);
        this.clearCaches();
        Iterable $this$map$iv2 = savedRestrictionsData.getUserGroups();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            UserGroupRestrictionData bl = (UserGroupRestrictionData)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new UserGroupRestriction(new Group(it.getGroupName()), it.getUseAnalytics()));
        }
        List list2 = (List)destination$iv$iv2;
        return new InstanceRestrictions(list2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SpaceRestrictions saveSpaceRestrictions(@NotNull String spaceKey, @NotNull List<String> userRestrictions, @NotNull List<String> userGroupRestrictions) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        String it;
        Collection<UserGroupRestrictionData> collection;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)spaceKey, (String)"spaceKey");
        Intrinsics.checkNotNullParameter(userRestrictions, (String)"userRestrictions");
        Intrinsics.checkNotNullParameter(userGroupRestrictions, (String)"userGroupRestrictions");
        Iterable $this$map$iv = userGroupRestrictions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupRestrictionData(it, true));
        }
        $this$map$iv = userRestrictions;
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new UserRestrictionData(it, true));
        }
        List list = (List)destination$iv$iv;
        Collection<UserGroupRestrictionData> collection3 = collection;
        SpaceRestrictionsData restrictionsData = new SpaceRestrictionsData((List<UserGroupRestrictionData>)collection3, list);
        Iterable $i$f$map2 = this.userService.getUserDetails(CollectionsKt.toSet((Iterable)userRestrictions), true);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void $i$f$mapTo2 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it2;
            User user = (User)element$iv$iv;
            Map map = destination$iv$iv2;
            boolean bl = false;
            map.put(it2.getUserKey(), element$iv$iv);
        }
        Map users = destination$iv$iv2;
        SpaceRestrictionsData savedRestrictionsData = this.restrictionsRepository.saveSpaceRestrictions(spaceKey, restrictionsData);
        this.clearCaches();
        return this.mapDataToSpaceRestrictions(savedRestrictionsData, users);
    }

    @EventListener
    public final void onGroupMembershipsCreatedEvent(@NotNull GroupMembershipsCreatedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Collection collection = event.getEntityNames();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getEntityNames(...)");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.clearUserFromCacheByUsername(it);
        }
    }

    @EventListener
    public final void onGroupMembershipDeletedEvent(@NotNull GroupMembershipDeletedEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        String string = event.getEntityName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEntityName(...)");
        this.clearUserFromCacheByUsername(string);
    }

    private final SpaceRestrictions mapDataToSpaceRestrictions(SpaceRestrictionsData restrictions, Map<String, User> users) {
        UserRestrictionData it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = restrictions.getUserGroups();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            UserGroupRestrictionData userGroupRestrictionData = (UserGroupRestrictionData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new UserGroupRestriction(new Group(((UserGroupRestrictionData)((Object)it)).getGroupName()), ((UserGroupRestrictionData)((Object)it)).getUseAnalytics()));
        }
        $this$map$iv = restrictions.getUsers();
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (UserRestrictionData)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            User user = users.get(it.getUserKey());
            Intrinsics.checkNotNull((Object)user);
            collection2.add(new UserRestriction(user, it.getUseAnalytics()));
        }
        List list = (List)destination$iv$iv;
        Collection collection3 = collection;
        return new SpaceRestrictions((List<UserGroupRestriction>)collection3, list);
    }

    private final boolean isUserAllowedToViewInstanceAnalyticsInternal(String userKey) {
        if (!this.userService.isUserLicensed(userKey)) {
            return false;
        }
        List<UserGroupRestrictionData> restrictions = this.restrictionsRepository.getInstanceRestrictions().getUserGroups();
        if (restrictions.isEmpty()) {
            return true;
        }
        List<Group> groupsUserIsIn = this.userService.getGroupsUserIsMemberOf(userKey);
        return this.isUserMemberOfAllowedGroups(restrictions, groupsUserIsIn);
    }

    private final boolean isUserAllowedToViewSpaceAnalyticsInternal(String userKey, String spaceKey) {
        boolean bl;
        SpaceRestrictionsData restrictions;
        block6: {
            if (!this.isUserAllowedToViewInstanceAnalytics(userKey)) {
                return false;
            }
            restrictions = this.restrictionsRepository.getSpaceRestrictions(spaceKey);
            if (restrictions.getUserGroups().isEmpty() && restrictions.getUsers().isEmpty()) {
                return true;
            }
            Iterable $this$any$iv = restrictions.getUsers();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    UserRestrictionData it = (UserRestrictionData)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUserKey(), (Object)userKey)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        List<Group> groupsUserIsIn = this.userService.getGroupsUserIsMemberOf(userKey);
        return this.isUserMemberOfAllowedGroups(restrictions.getUserGroups(), groupsUserIsIn);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isUserMemberOfAllowedGroups(List<UserGroupRestrictionData> userGroupRestrictions, List<Group> groupsUserIsIn) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        UserGroupRestrictionData it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = userGroupRestrictions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (UserGroupRestrictionData)element$iv$iv;
            boolean bl = false;
            if (!it.getUseAnalytics()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (UserGroupRestrictionData)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getGroupName());
        }
        List allowedGroups = (List)destination$iv$iv;
        Iterable $this$map$iv2 = groupsUserIsIn;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Group bl = (Group)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it2.getName());
        }
        Set groupNamesUserIsIn = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        return !((Collection)CollectionsKt.intersect((Iterable)allowedGroups, (Iterable)groupNamesUserIsIn)).isEmpty();
    }

    private final Cache<String, Boolean> buildInstanceCache() {
        Cache cache = this.cacheManager.getCache("Analytics for Confluence - Instance Permissions", null, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(this.confluenceInfoService.isDataCenter() ? 25000 : 10000).expireAfterWrite(24L, TimeUnit.HOURS).build());
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"getCache(...)");
        return cache;
    }

    private final Cache<String, Boolean> buildSpacesCache() {
        Cache cache = this.cacheManager.getCache("Analytics for Confluence - Space Permissions", null, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(this.confluenceInfoService.isDataCenter() ? 125000 : 50000).expireAfterWrite(24L, TimeUnit.HOURS).build());
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"getCache(...)");
        return cache;
    }

    private final void clearCaches() {
        this.instanceRestrictionsCache.removeAll();
        this.spaceRestrictionsCache.removeAll();
    }

    private final void clearUserFromCacheByUsername(String userName) {
        this.log.debug("Group membership changed, clearing permission caches for user {}", (Object)userName);
        String userKey = this.userService.getUserKeyByUsername(userName);
        if (userKey == null) {
            this.log.debug("Couldn't resolve username. Clearing the whole instance restrictions cache");
            this.instanceRestrictionsCache.removeAll();
        } else {
            this.instanceRestrictionsCache.remove((Object)userKey);
        }
        this.spaceRestrictionsCache.removeAll();
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private static final Boolean isUserAllowedToViewInstanceAnalytics$lambda$1$lambda$0(RestrictionsServiceImpl this$0, String $userKey) {
        return this$0.isUserAllowedToViewInstanceAnalyticsInternal($userKey);
    }

    private static final Boolean isUserAllowedToViewSpaceAnalytics$lambda$3$lambda$2(RestrictionsServiceImpl this$0, String $userKey, String $spaceKey) {
        return this$0.isUserAllowedToViewSpaceAnalyticsInternal($userKey, $spaceKey);
    }
}

