/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service;

import com.addonengine.addons.analytics.service.HashService;
import com.addonengine.addons.analytics.service.SettingsService;
import com.addonengine.addons.analytics.service.model.settings.DataRetentionSettings;
import com.addonengine.addons.analytics.service.model.settings.EventLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.NewDataRetentionSettings;
import com.addonengine.addons.analytics.service.model.settings.NewEventLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.NewPrivacySettings;
import com.addonengine.addons.analytics.service.model.settings.NewRateLimitSettings;
import com.addonengine.addons.analytics.service.model.settings.PrivacySettings;
import com.addonengine.addons.analytics.service.model.settings.RateLimitSettings;
import com.addonengine.addons.analytics.store.SettingsRepository;
import com.addonengine.addons.analytics.store.model.DataRetentionSettingsData;
import com.addonengine.addons.analytics.store.model.EventLimitSettingsData;
import com.addonengine.addons.analytics.store.model.PrivacySettingsData;
import com.addonengine.addons.analytics.store.model.RateLimitSettingsData;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.util.profiling.UtilTimerStack;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExportAsDevService(value={SettingsService.class})
@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 62\u00020\u0001:\u000267B-\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J\u001f\u0010\"\u001a\u00020\u00132\u0006\u0010 \u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010 \u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0011H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\b\u00101\u001a\u00020\u001eH\u0002J\b\u00102\u001a\u00020\u0015H\u0002J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020\u000eH\u0002J\u0014\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/addonengine/addons/analytics/service/SettingsServiceImpl;", "Lcom/addonengine/addons/analytics/service/SettingsService;", "cacheManager", "Lcom/atlassian/cache/CacheManager;", "settingsRepository", "Lcom/addonengine/addons/analytics/store/SettingsRepository;", "hashService", "Lcom/addonengine/addons/analytics/service/HashService;", "timezoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "<init>", "(Lcom/atlassian/cache/CacheManager;Lcom/addonengine/addons/analytics/store/SettingsRepository;Lcom/addonengine/addons/analytics/service/HashService;Lcom/atlassian/sal/api/timezone/TimeZoneManager;)V", "settingsCache", "Lcom/atlassian/cache/Cache;", "Lcom/addonengine/addons/analytics/service/SettingsServiceImpl$Setting;", "", "getPrivacySettings", "Lcom/addonengine/addons/analytics/service/model/settings/PrivacySettings;", "getDataRetentionSettings", "Lcom/addonengine/addons/analytics/service/model/settings/DataRetentionSettings;", "getRateLimitSettings", "Lcom/addonengine/addons/analytics/service/model/settings/RateLimitSettings;", "getDataRetentionActive", "", "effectiveFrom", "Ljava/time/Instant;", "getDataRetentionMinDate", "months", "", "getEventLimitSettings", "Lcom/addonengine/addons/analytics/service/model/settings/EventLimitSettings;", "setPrivacySettings", "newSettings", "Lcom/addonengine/addons/analytics/service/model/settings/NewPrivacySettings;", "setDataRetentionSettings", "Lcom/addonengine/addons/analytics/service/model/settings/NewDataRetentionSettings;", "gracePeriod", "", "(Lcom/addonengine/addons/analytics/service/model/settings/NewDataRetentionSettings;Ljava/lang/Integer;)Lcom/addonengine/addons/analytics/service/model/settings/DataRetentionSettings;", "setEventLimitSettings", "Lcom/addonengine/addons/analytics/service/model/settings/NewEventLimitSettings;", "setRateLimitSettings", "Lcom/addonengine/addons/analytics/service/model/settings/NewRateLimitSettings;", "clearPrivacySettings", "", "serverTimezone", "Ljava/time/ZoneId;", "getPrivacySettingsInternal", "getDataRetentionSettingsInternal", "getDataLimitSettingsInternal", "getRateLimitSettingsInternal", "clearCache", "setting", "buildSettingsCache", "Companion", "Setting", "analytics"})
@SourceDebugExtension(value={"SMAP\nSettingsServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsServiceImpl.kt\ncom/addonengine/addons/analytics/service/SettingsServiceImpl\n+ 2 utils.kt\ncom/addonengine/addons/analytics/util/UtilsKt\n*L\n1#1,235:1\n11#2,11:236\n11#2,11:247\n11#2,11:258\n11#2,11:269\n*S KotlinDebug\n*F\n+ 1 SettingsServiceImpl.kt\ncom/addonengine/addons/analytics/service/SettingsServiceImpl\n*L\n48#1:236,11\n54#1:247,11\n60#1:258,11\n74#1:269,11\n*E\n"})
public final class SettingsServiceImpl
implements SettingsService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CacheManager cacheManager;
    @NotNull
    private final SettingsRepository settingsRepository;
    @NotNull
    private final HashService hashService;
    @NotNull
    private final TimeZoneManager timezoneManager;
    @NotNull
    private final Cache<Setting, Object> settingsCache;
    private static final int MIN_CONCURRENT_OPS_PER_SESSION = 4;

    @Inject
    public SettingsServiceImpl(@ComponentImport @NotNull CacheManager cacheManager, @NotNull SettingsRepository settingsRepository, @NotNull HashService hashService, @ComponentImport @NotNull TimeZoneManager timezoneManager) {
        Intrinsics.checkNotNullParameter((Object)cacheManager, (String)"cacheManager");
        Intrinsics.checkNotNullParameter((Object)settingsRepository, (String)"settingsRepository");
        Intrinsics.checkNotNullParameter((Object)hashService, (String)"hashService");
        Intrinsics.checkNotNullParameter((Object)timezoneManager, (String)"timezoneManager");
        this.cacheManager = cacheManager;
        this.settingsRepository = settingsRepository;
        this.hashService = hashService;
        this.timezoneManager = timezoneManager;
        this.settingsCache = this.buildSettingsCache();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PrivacySettings getPrivacySettings() {
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "getPrivacySettings";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            void klass$iv;
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Object object = this.settingsCache.get((Object)Setting.PRIVACY, this::getPrivacySettingsInternal);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.addonengine.addons.analytics.service.model.settings.PrivacySettings");
        return (PrivacySettings)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DataRetentionSettings getDataRetentionSettings() {
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "getDataRetentionSettings";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            void klass$iv;
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Object object = this.settingsCache.get((Object)Setting.DATA_RETENTION, this::getDataRetentionSettingsInternal);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.addonengine.addons.analytics.service.model.settings.DataRetentionSettings");
        return (DataRetentionSettings)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public RateLimitSettings getRateLimitSettings() {
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "getRateLimitSettings";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            void klass$iv;
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Object object = this.settingsCache.get((Object)Setting.RATE_LIMIT, this::getRateLimitSettingsInternal);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.addonengine.addons.analytics.service.model.settings.RateLimitSettings");
        return (RateLimitSettings)object;
    }

    public final boolean getDataRetentionActive(@NotNull Instant effectiveFrom) {
        Intrinsics.checkNotNullParameter((Object)effectiveFrom, (String)"effectiveFrom");
        return Instant.now().isAfter(effectiveFrom);
    }

    @NotNull
    public final Instant getDataRetentionMinDate(long months) {
        Instant instant = Instant.now().atOffset(ZoneOffset.UTC).minusMonths(months).truncatedTo(ChronoUnit.DAYS).toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return instant;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public EventLimitSettings getEventLimitSettings() {
        KClass kClass = Reflection.getOrCreateKotlinClass(this.getClass());
        String name$iv = "getEventLimitSettings";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            void klass$iv;
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Object object = this.settingsCache.get((Object)Setting.EVENT_LIMITS, this::getDataLimitSettingsInternal);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.addonengine.addons.analytics.service.model.settings.EventLimitSettings");
        return (EventLimitSettings)object;
    }

    @Override
    @NotNull
    public PrivacySettings setPrivacySettings(@NotNull NewPrivacySettings newSettings) {
        PrivacySettingsData privacySettingsData;
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        PrivacySettingsData existingSettingsData = this.settingsRepository.getPrivacySettings();
        if (newSettings.getEnabled() && existingSettingsData.getInstanceSalt() == null) {
            String instanceSalt = this.hashService.generateInstanceSalt();
            privacySettingsData = new PrivacySettingsData(newSettings.getEnabled(), instanceSalt);
        } else {
            privacySettingsData = new PrivacySettingsData(newSettings.getEnabled(), existingSettingsData.getInstanceSalt());
        }
        PrivacySettingsData newSettingsData = privacySettingsData;
        PrivacySettingsData savedPrivacyData = this.settingsRepository.setPrivacySettings(newSettingsData);
        this.clearCache(Setting.PRIVACY);
        return new PrivacySettings(savedPrivacyData.getEnabled(), savedPrivacyData.getInstanceSalt());
    }

    @Override
    @NotNull
    public DataRetentionSettings setDataRetentionSettings(@NotNull NewDataRetentionSettings newSettings, @Nullable Integer gracePeriod) {
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        Integer n = gracePeriod;
        int gracePeriodDays = n != null ? n : (newSettings.getCustomised() ? 1 : 14);
        boolean bl = newSettings.getCustomised();
        int n2 = newSettings.getMonths();
        Instant instant = Instant.now().plus((long)gracePeriodDays, ChronoUnit.DAYS);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"plus(...)");
        DataRetentionSettingsData savedSettings = this.settingsRepository.setDataRetentionSettings(new DataRetentionSettingsData(true, bl, n2, instant));
        this.clearCache(Setting.DATA_RETENTION);
        return new DataRetentionSettings(this.getDataRetentionActive(savedSettings.getEffectiveFrom()), savedSettings.getCustomised(), savedSettings.getMonths(), this.getDataRetentionMinDate(savedSettings.getMonths()));
    }

    @Override
    @NotNull
    public EventLimitSettings setEventLimitSettings(@NotNull NewEventLimitSettings newSettings) {
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        EventLimitSettingsData savedSettings = this.settingsRepository.setEventLimitSettings(new EventLimitSettingsData(newSettings.getMaxRowCount()));
        this.clearCache(Setting.EVENT_LIMITS);
        return new EventLimitSettings(savedSettings.getMaxRowCount());
    }

    @Override
    @NotNull
    public RateLimitSettings setRateLimitSettings(@NotNull NewRateLimitSettings newSettings) {
        Intrinsics.checkNotNullParameter((Object)newSettings, (String)"newSettings");
        RateLimitSettingsData savedRateLimitData = this.settingsRepository.setRateLimitSettings(new RateLimitSettingsData(newSettings.getEnabled(), newSettings.getConcurrentSessions(), newSettings.getStaleOperationSeconds(), Math.max(MIN_CONCURRENT_OPS_PER_SESSION, newSettings.getConcurrentOperationsPerSession())));
        this.clearCache(Setting.RATE_LIMIT);
        return new RateLimitSettings(savedRateLimitData.getEnabled(), savedRateLimitData.getConcurrentSessions(), savedRateLimitData.getStaleOperationSeconds(), savedRateLimitData.getConcurrentOperationsPerSession());
    }

    @Override
    public void clearPrivacySettings() {
        this.settingsRepository.deletePrivacySettings();
        this.clearCache(Setting.PRIVACY);
    }

    @Override
    @NotNull
    public ZoneId serverTimezone() {
        ZoneId zoneId = ZoneId.of(this.timezoneManager.getDefaultTimeZone().getID());
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        return zoneId;
    }

    private final PrivacySettings getPrivacySettingsInternal() {
        PrivacySettingsData settings = this.settingsRepository.getPrivacySettings();
        return new PrivacySettings(settings.getEnabled(), settings.getInstanceSalt());
    }

    private final DataRetentionSettings getDataRetentionSettingsInternal() {
        DataRetentionSettingsData settings = this.settingsRepository.getDataRetentionSettings();
        int months = settings.getExists() ? settings.getMonths() : 12;
        return new DataRetentionSettings(settings.getExists() ? this.getDataRetentionActive(settings.getEffectiveFrom()) : true, settings.getExists() && settings.getCustomised(), months, this.getDataRetentionMinDate(months));
    }

    private final EventLimitSettings getDataLimitSettingsInternal() {
        EventLimitSettingsData settings = this.settingsRepository.getEventLimitSettings();
        return new EventLimitSettings(settings.getMaxRowCount());
    }

    private final RateLimitSettings getRateLimitSettingsInternal() {
        RateLimitSettingsData settings = this.settingsRepository.getRateLimitSettings();
        return new RateLimitSettings(settings.getEnabled(), settings.getConcurrentSessions(), settings.getStaleOperationSeconds(), Math.max(MIN_CONCURRENT_OPS_PER_SESSION, settings.getConcurrentOperationsPerSession()));
    }

    private final void clearCache(Setting setting) {
        this.settingsCache.remove((Object)setting);
    }

    private final Cache<Setting, Object> buildSettingsCache() {
        Cache cache = this.cacheManager.getCache("Analytics for Confluence - Settings", null, new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(100).expireAfterWrite(24L, TimeUnit.HOURS).build());
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"getCache(...)");
        return cache;
    }

    public static final int getMIN_CONCURRENT_OPS_PER_SESSION() {
        return Companion.getMIN_CONCURRENT_OPS_PER_SESSION();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/addonengine/addons/analytics/service/SettingsServiceImpl$Companion;", "", "<init>", "()V", "MIN_CONCURRENT_OPS_PER_SESSION", "", "getMIN_CONCURRENT_OPS_PER_SESSION$annotations", "getMIN_CONCURRENT_OPS_PER_SESSION", "()I", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMIN_CONCURRENT_OPS_PER_SESSION() {
            return MIN_CONCURRENT_OPS_PER_SESSION;
        }

        @JvmStatic
        public static /* synthetic */ void getMIN_CONCURRENT_OPS_PER_SESSION$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/addonengine/addons/analytics/service/SettingsServiceImpl$Setting;", "", "<init>", "(Ljava/lang/String;I)V", "PRIVACY", "DATA_RETENTION", "EVENT_LIMITS", "RATE_LIMIT", "analytics"})
    private static final class Setting
    extends Enum<Setting> {
        public static final /* enum */ Setting PRIVACY = new Setting();
        public static final /* enum */ Setting DATA_RETENTION = new Setting();
        public static final /* enum */ Setting EVENT_LIMITS = new Setting();
        public static final /* enum */ Setting RATE_LIMIT = new Setting();
        private static final /* synthetic */ Setting[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Setting[] values() {
            return (Setting[])$VALUES.clone();
        }

        public static Setting valueOf(String value) {
            return Enum.valueOf(Setting.class, value);
        }

        @NotNull
        public static EnumEntries<Setting> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = settingArray = new Setting[]{Setting.PRIVACY, Setting.DATA_RETENTION, Setting.EVENT_LIMITS, Setting.RATE_LIMIT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

