/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service.confluence.server;

import com.addonengine.addons.analytics.service.confluence.LicenseService;
import com.addonengine.addons.analytics.service.confluence.model.LicenseStatus;
import com.addonengine.addons.analytics.util.UtilsKt;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsDevService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExportAsDevService(value={LicenseService.class})
@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lcom/addonengine/addons/analytics/service/confluence/server/LicenseServiceServerImpl;", "Lcom/addonengine/addons/analytics/service/confluence/LicenseService;", "pluginLicenseManager", "Lcom/atlassian/upm/api/license/PluginLicenseManager;", "productLicenseService", "Lcom/atlassian/confluence/license/LicenseService;", "<init>", "(Lcom/atlassian/upm/api/license/PluginLicenseManager;Lcom/atlassian/confluence/license/LicenseService;)V", "statusOverride", "Lcom/addonengine/addons/analytics/service/confluence/model/LicenseStatus;", "getStatusOverride", "()Lcom/addonengine/addons/analytics/service/confluence/model/LicenseStatus;", "setStatusOverride", "(Lcom/addonengine/addons/analytics/service/confluence/model/LicenseStatus;)V", "getStatus", "getAppLicenseStatus", "getLicensedUserCount", "", "setStatusForTesting", "", "status", "analytics"})
public final class LicenseServiceServerImpl
implements LicenseService {
    @NotNull
    private final PluginLicenseManager pluginLicenseManager;
    @NotNull
    private final com.atlassian.confluence.license.LicenseService productLicenseService;
    @Nullable
    private LicenseStatus statusOverride;

    @Inject
    public LicenseServiceServerImpl(@ComponentImport @NotNull PluginLicenseManager pluginLicenseManager, @ComponentImport @NotNull com.atlassian.confluence.license.LicenseService productLicenseService) {
        Intrinsics.checkNotNullParameter((Object)pluginLicenseManager, (String)"pluginLicenseManager");
        Intrinsics.checkNotNullParameter((Object)productLicenseService, (String)"productLicenseService");
        this.pluginLicenseManager = pluginLicenseManager;
        this.productLicenseService = productLicenseService;
    }

    @Nullable
    public final LicenseStatus getStatusOverride() {
        return this.statusOverride;
    }

    public final void setStatusOverride(@Nullable LicenseStatus licenseStatus) {
        this.statusOverride = licenseStatus;
    }

    @Override
    @NotNull
    public LicenseStatus getStatus() {
        return this.productLicenseService.isLicensedForDataCenterOrExempt() ? LicenseStatus.VALID : this.getAppLicenseStatus();
    }

    private final LicenseStatus getAppLicenseStatus() {
        if (ConfluenceSystemProperties.isDevMode() && this.statusOverride != null) {
            LicenseStatus licenseStatus = this.statusOverride;
            Intrinsics.checkNotNull((Object)((Object)licenseStatus), (String)"null cannot be cast to non-null type com.addonengine.addons.analytics.service.confluence.model.LicenseStatus");
            return licenseStatus;
        }
        if (UtilsKt.isAddonDevMode()) {
            return LicenseStatus.VALID;
        }
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            Object object = this.pluginLicenseManager.getLicense().get();
            Intrinsics.checkNotNull((Object)object);
            PluginLicense license = (PluginLicense)object;
            if (license.getError().isDefined()) {
                Object object2 = license.getError().get();
                Intrinsics.checkNotNull((Object)object2);
                return switch (WhenMappings.$EnumSwitchMapping$0[((LicenseError)object2).ordinal()]) {
                    case 1 -> LicenseStatus.EXPIRED;
                    case 2 -> LicenseStatus.TYPE_MISMATCH;
                    case 3 -> LicenseStatus.USER_MISMATCH;
                    case 4 -> LicenseStatus.EDITION_MISMATCH;
                    case 5 -> LicenseStatus.ROLE_EXCEEDED;
                    case 6 -> LicenseStatus.ROLE_UNDEFINED;
                    case 7 -> LicenseStatus.VERSION_MISMATCH;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
            return LicenseStatus.VALID;
        }
        return LicenseStatus.UNLICENSED;
    }

    @Override
    public int getLicensedUserCount() {
        if (this.productLicenseService.isLicensedForDataCenterOrExempt()) {
            return this.productLicenseService.retrieve().getMaximumNumberOfUsers();
        }
        Object object = this.pluginLicenseManager.getCurrentUserCountInLicenseRole().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    @Override
    public void setStatusForTesting(@Nullable LicenseStatus status) {
        this.statusOverride = status;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LicenseError.values().length];
            try {
                nArray[LicenseError.EXPIRED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.TYPE_MISMATCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.USER_MISMATCH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.EDITION_MISMATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.ROLE_EXCEEDED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.ROLE_UNDEFINED.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LicenseError.VERSION_MISMATCH.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

