/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service.confluence.server;

import com.addonengine.addons.analytics.service.confluence.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.net.WWWFormCodec;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0016J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\tH\u0016J,\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\b\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/addonengine/addons/analytics/service/confluence/server/UrlBuilderServerImpl;", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "applicationProperties", "Lcom/atlassian/sal/api/ApplicationProperties;", "<init>", "(Lcom/atlassian/sal/api/ApplicationProperties;)V", "buildHostCanonicalUri", "Ljava/net/URL;", "path", "", "buildUrl", "baseUrl", "addonKey", "actionName", "adminLink", "", "buildHostAdminActionUrl", "buildHostActionUrl", "queryString", "", "administration", "getBaseUrl", "getAnonymousUserProfilePictureUrl", "analytics"})
@SourceDebugExtension(value={"SMAP\nUrlBuilderServerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlBuilderServerImpl.kt\ncom/addonengine/addons/analytics/service/confluence/server/UrlBuilderServerImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,48:1\n126#2:49\n153#2,3:50\n*S KotlinDebug\n*F\n+ 1 UrlBuilderServerImpl.kt\ncom/addonengine/addons/analytics/service/confluence/server/UrlBuilderServerImpl\n*L\n39#1:49\n39#1:50,3\n*E\n"})
public final class UrlBuilderServerImpl
implements UrlBuilder {
    @NotNull
    private final ApplicationProperties applicationProperties;

    @Inject
    public UrlBuilderServerImpl(@ComponentImport @NotNull ApplicationProperties applicationProperties) {
        Intrinsics.checkNotNullParameter((Object)applicationProperties, (String)"applicationProperties");
        this.applicationProperties = applicationProperties;
    }

    @Override
    @NotNull
    public URL buildHostCanonicalUri(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new URL(this.getBaseUrl() + path);
    }

    private final String buildUrl(String baseUrl, String addonKey, String actionName, boolean adminLink) {
        return adminLink ? baseUrl + "/admin/plugins/" + addonKey + "/" + actionName + ".action" : baseUrl + "/plugins/" + addonKey + "/" + actionName + ".action";
    }

    @Override
    @NotNull
    public URL buildHostAdminActionUrl(@NotNull String actionName) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        return this.buildHostActionUrl(actionName, MapsKt.emptyMap(), true);
    }

    @Override
    @NotNull
    public URL buildHostActionUrl(@NotNull String actionName) {
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        return this.buildHostActionUrl(actionName, MapsKt.emptyMap(), false);
    }

    /*
     * WARNING - void declaration
     */
    private final URL buildHostActionUrl(String actionName, Map<String, String> queryString, boolean administration) {
        void $this$mapTo$iv$iv;
        String baseUrl = this.getBaseUrl();
        String addonPath = "confanalytics";
        Map<String, String> $this$map$iv = queryString;
        boolean $i$f$map = false;
        Map<String, String> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new BasicNameValuePair((String)it.getKey(), (String)it.getValue()));
        }
        String queryString2 = WWWFormCodec.format((Iterable)((List)destination$iv$iv), (Charset)StandardCharsets.UTF_8);
        String url = this.buildUrl(baseUrl, addonPath, actionName, administration);
        Intrinsics.checkNotNull((Object)queryString2);
        return new URL((String)(((CharSequence)queryString2).length() == 0 ? url : url + "?" + queryString2));
    }

    @Override
    @NotNull
    public String getBaseUrl() {
        String string = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBaseUrl(...)");
        return string;
    }

    @Override
    @NotNull
    public String getAnonymousUserProfilePictureUrl() {
        String string = this.buildHostCanonicalUri("/images/icons/profilepics/anonymous.png").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

