/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.service.excel;

import com.addonengine.addons.analytics.service.SpacePaginatedAnalyticsService;
import com.addonengine.addons.analytics.service.SpacePaginatedAnalyticsServiceImpl;
import com.addonengine.addons.analytics.service.excel.SpaceActivityByContentExcelService;
import com.addonengine.addons.analytics.service.excel.model.ExcelReport;
import com.addonengine.addons.analytics.service.excel.poi.ExcelCellStyles;
import com.addonengine.addons.analytics.service.excel.poi.ExcelColumnHeader;
import com.addonengine.addons.analytics.service.excel.poi.ExcelReportSXSSFWorkbookImpl;
import com.addonengine.addons.analytics.service.excel.poi.ExcelSXSSFService;
import com.addonengine.addons.analytics.service.model.ContentActivity;
import com.addonengine.addons.analytics.service.model.ContentSortField;
import com.addonengine.addons.analytics.service.model.ContentType;
import com.addonengine.addons.analytics.service.model.DatePeriodOptions;
import com.addonengine.addons.analytics.service.model.LazyFetching;
import com.addonengine.addons.analytics.service.model.SortOrder;
import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Named;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\b\u0007\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0017\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0001\u00a2\u0006\u0002\b J\u0019\u0010!\u001a\u0004\u0018\u00010\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0001\u00a2\u0006\u0002\b\"R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0016\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/addonengine/addons/analytics/service/excel/SpaceActivityByContentExcelServiceImpl;", "Lcom/addonengine/addons/analytics/service/excel/poi/ExcelSXSSFService;", "Lcom/addonengine/addons/analytics/service/excel/SpaceActivityByContentExcelService;", "i18n", "Lcom/atlassian/sal/api/message/I18nResolver;", "paginatedService", "Lcom/addonengine/addons/analytics/service/SpacePaginatedAnalyticsService;", "<init>", "(Lcom/atlassian/sal/api/message/I18nResolver;Lcom/addonengine/addons/analytics/service/SpacePaginatedAnalyticsService;)V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "batchSize", "", "Ljava/lang/Integer;", "csvInjectionPattern", "Ljava/util/regex/Pattern;", "columnHeaders", "", "Lcom/addonengine/addons/analytics/service/excel/poi/ExcelColumnHeader;", "buildExcelReport", "Lcom/addonengine/addons/analytics/service/excel/model/ExcelReport;", "datePeriodOptions", "Lcom/addonengine/addons/analytics/service/model/DatePeriodOptions;", "contentTypes", "", "Lcom/addonengine/addons/analytics/service/model/ContentType;", "spaceKey", "", "isAffectedByCsvInjection", "", "input", "isAffectedByCsvInjection$analytics", "getSanitizedText", "getSanitizedText$analytics", "analytics"})
@SourceDebugExtension(value={"SMAP\nSpaceActivityByContentExcelServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpaceActivityByContentExcelServiceImpl.kt\ncom/addonengine/addons/analytics/service/excel/SpaceActivityByContentExcelServiceImpl\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,143:1\n1332#2,3:144\n*S KotlinDebug\n*F\n+ 1 SpaceActivityByContentExcelServiceImpl.kt\ncom/addonengine/addons/analytics/service/excel/SpaceActivityByContentExcelServiceImpl\n*L\n109#1:144,3\n*E\n"})
public final class SpaceActivityByContentExcelServiceImpl
extends ExcelSXSSFService
implements SpaceActivityByContentExcelService {
    @NotNull
    private final I18nResolver i18n;
    @NotNull
    private final SpacePaginatedAnalyticsService paginatedService;
    private final Logger log;
    private final Integer batchSize;
    private final Pattern csvInjectionPattern;
    @NotNull
    private final List<ExcelColumnHeader> columnHeaders;

    @Autowired
    public SpaceActivityByContentExcelServiceImpl(@ComponentImport @NotNull I18nResolver i18n, @NotNull SpacePaginatedAnalyticsService paginatedService) {
        Intrinsics.checkNotNullParameter((Object)i18n, (String)"i18n");
        Intrinsics.checkNotNullParameter((Object)paginatedService, (String)"paginatedService");
        super(i18n);
        this.i18n = i18n;
        this.paginatedService = paginatedService;
        this.log = LoggerFactory.getLogger(SpacePaginatedAnalyticsServiceImpl.class);
        this.batchSize = Integer.getInteger("confluence.analytics.pagination.xls.batch.size", 25000);
        this.csvInjectionPattern = Pattern.compile("^[=+\\-@\\t\\r\\n]");
        Object[] objectArray = new ExcelColumnHeader[]{new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.title", 60, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.link", 60, true), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.created", 20, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.lastModified", 20, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.lastViewed", 20, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.commentActivity", 20, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.usersViewed", 15, false, 4, null), new ExcelColumnHeader("com.addonengine.addons.analytics.excel.space.content.header.views", 10, false, 4, null)};
        this.columnHeaders = CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ExcelReport buildExcelReport(@NotNull DatePeriodOptions datePeriodOptions, @NotNull Set<? extends ContentType> contentTypes, @NotNull String spaceKey) {
        Intrinsics.checkNotNullParameter((Object)datePeriodOptions, (String)"datePeriodOptions");
        Intrinsics.checkNotNullParameter(contentTypes, (String)"contentTypes");
        Intrinsics.checkNotNullParameter((Object)spaceKey, (String)"spaceKey");
        this.log.info("Generating Analytics report for spaceKey : " + spaceKey);
        Integer n = this.batchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"batchSize");
        int n2 = ((Number)n).intValue();
        Integer n3 = this.batchSize;
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"batchSize");
        Sequence activityByContent2 = LazyFetching.Companion.numerical(n2, ((Number)n3).intValue(), (arg_0, arg_1) -> SpaceActivityByContentExcelServiceImpl.buildExcelReport$lambda$0(this, datePeriodOptions, spaceKey, contentTypes, arg_0, arg_1)).asSequence();
        SXSSFWorkbook workbook = this.createWorkbook();
        ExcelCellStyles cellStyles = this.buildDefaultWorkbookStyles(workbook);
        SXSSFSheet sheet = this.createWorksheet(workbook, "com.addonengine.addons.analytics.excel.space.content.sheetName");
        this.buildColumnHeaderRow(sheet, cellStyles, this.columnHeaders);
        Sequence $this$forEachIndexed$iv = activityByContent2;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void contentActivity;
            int n4;
            if ((n4 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ContentActivity contentActivity2 = (ContentActivity)item$iv;
            int index = n4;
            boolean bl = false;
            Object[] objectArray = new Serializable[]{this.getSanitizedText$analytics(contentActivity.getContent().getTitle()), contentActivity.getContent().getLink(), contentActivity.getContent().getCreatedAt(), contentActivity.getContent().getLastModifiedAt(), contentActivity.getLastViewedAt(), Long.valueOf(contentActivity.getCommentActivityCount()), Long.valueOf(contentActivity.getUsersViewed()), Long.valueOf(contentActivity.getViews())};
            this.buildDataRow(sheet, index, datePeriodOptions.getTimezone(), cellStyles, CollectionsKt.listOf((Object[])objectArray));
        }
        this.log.info("Finished generating Analytics report for spaceKey : " + spaceKey);
        return new ExcelReportSXSSFWorkbookImpl(workbook);
    }

    @VisibleForTesting
    public final boolean isAffectedByCsvInjection$analytics(@Nullable String input) {
        CharSequence charSequence = input;
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        return this.csvInjectionPattern.matcher(input).find();
    }

    @VisibleForTesting
    @Nullable
    public final String getSanitizedText$analytics(@Nullable String input) {
        if (!this.isAffectedByCsvInjection$analytics(input)) {
            return input;
        }
        String string = input;
        String escaped = string != null ? StringsKt.replace$default((String)string, (String)"\"", (String)"\"\"", (boolean)false, (int)4, null) : null;
        return "\t" + escaped;
    }

    private static final List buildExcelReport$lambda$0(SpaceActivityByContentExcelServiceImpl this$0, DatePeriodOptions $datePeriodOptions, String $spaceKey, Set $contentTypes, int offset, int limit) {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ContentActivity>>, Object>(this$0, $datePeriodOptions, $spaceKey, (Set<? extends ContentType>)$contentTypes, offset, limit, null){
            int label;
            final /* synthetic */ SpaceActivityByContentExcelServiceImpl this$0;
            final /* synthetic */ DatePeriodOptions $datePeriodOptions;
            final /* synthetic */ String $spaceKey;
            final /* synthetic */ Set<ContentType> $contentTypes;
            final /* synthetic */ int $offset;
            final /* synthetic */ int $limit;
            {
                this.this$0 = $receiver;
                this.$datePeriodOptions = $datePeriodOptions;
                this.$spaceKey = $spaceKey;
                this.$contentTypes = $contentTypes;
                this.$offset = $offset;
                this.$limit = $limit;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SpaceActivityByContentExcelServiceImpl.access$getPaginatedService$p(this.this$0).getActivityByContentInBatches(this.$datePeriodOptions, this.$spaceKey, this.$contentTypes, this.$offset, this.$limit, ContentSortField.CONTENT_NAME, SortOrder.ASC, (Continuation<? super List<ContentActivity>>)((Continuation)this));
                        Object object4 = object3;
                        if (object3 != object2) return (List)object4;
                        return object2;
                    }
                    case 1: {
                        Object object4;
                        try {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            object4 = $result;
                            return (List)object4;
                        }
                        catch (Exception e) {
                            SpaceActivityByContentExcelServiceImpl.access$getLog$p(this.this$0).warn("Failed to fetch activity by content for offset=" + this.$offset + ", limit=" + this.$limit + ": " + e.getMessage(), (Throwable)e);
                            throw e;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<ContentActivity>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ SpacePaginatedAnalyticsService access$getPaginatedService$p(SpaceActivityByContentExcelServiceImpl $this) {
        return $this.paginatedService;
    }

    public static final /* synthetic */ Logger access$getLog$p(SpaceActivityByContentExcelServiceImpl $this) {
        return $this.log;
    }
}

