/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.store.server.querydsl;

import com.addonengine.addons.analytics.store.server.querydsl.template.ExtendedH2Template;
import com.addonengine.addons.analytics.store.server.querydsl.template.ExtendedMysqlTemplate;
import com.addonengine.addons.analytics.store.server.querydsl.template.ExtendedOracleTemplate;
import com.addonengine.addons.analytics.store.server.querydsl.template.ExtendedPostgresTemplate;
import com.addonengine.addons.analytics.store.server.querydsl.template.ExtendedSqlServerTemplate;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.DB2Templates;
import com.querydsl.sql.DerbyTemplates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.SQLTemplates;
import com.querydsl.sql.namemapping.NameMapping;
import com.querydsl.sql.namemapping.PreConfiguredNameMapping;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001d\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J/\u0010\u000f\u001a\u0002H\u0010\"\u0004\b\u0000\u0010\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H\u00100\u0014\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/addonengine/addons/analytics/store/server/querydsl/QueryDslDbConnectionManager;", "", "provider", "Lcom/atlassian/activeobjects/spi/DataSourceProvider;", "transactionalExecutorFactory", "Lcom/atlassian/sal/api/rdbms/TransactionalExecutorFactory;", "<init>", "(Lcom/atlassian/activeobjects/spi/DataSourceProvider;Lcom/atlassian/sal/api/rdbms/TransactionalExecutorFactory;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "SQLSERVER_2005", "", "SQLSERVER_2008", "SQLSERVER_2012", "execute", "T", "readOnly", "", "callback", "Lkotlin/Function1;", "Lcom/querydsl/sql/SQLQueryFactory;", "(ZLkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "setCasingRulesBasedOnDbms", "", "configuration", "Lcom/querydsl/sql/Configuration;", "getDialect", "Lcom/querydsl/sql/SQLTemplates;", "metaData", "Ljava/sql/DatabaseMetaData;", "analytics"})
@SourceDebugExtension(value={"SMAP\nQueryDslDbConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QueryDslDbConnectionManager.kt\ncom/addonengine/addons/analytics/store/server/querydsl/QueryDslDbConnectionManager\n+ 2 utils.kt\ncom/addonengine/addons/analytics/util/UtilsKt\n*L\n1#1,125:1\n11#2,11:126\n*S KotlinDebug\n*F\n+ 1 QueryDslDbConnectionManager.kt\ncom/addonengine/addons/analytics/store/server/querydsl/QueryDslDbConnectionManager\n*L\n55#1:126,11\n*E\n"})
public final class QueryDslDbConnectionManager {
    @NotNull
    private final DataSourceProvider provider;
    @NotNull
    private final TransactionalExecutorFactory transactionalExecutorFactory;
    private final Logger logger;
    private final int SQLSERVER_2005;
    private final int SQLSERVER_2008;
    private final int SQLSERVER_2012;

    @Inject
    public QueryDslDbConnectionManager(@ComponentImport @NotNull DataSourceProvider provider, @ComponentImport @NotNull TransactionalExecutorFactory transactionalExecutorFactory) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)transactionalExecutorFactory, (String)"transactionalExecutorFactory");
        this.provider = provider;
        this.transactionalExecutorFactory = transactionalExecutorFactory;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.SQLSERVER_2005 = 9;
        this.SQLSERVER_2008 = 10;
        this.SQLSERVER_2012 = 11;
    }

    public final <T> T execute(boolean readOnly, @NotNull Function1<? super SQLQueryFactory, ? extends T> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        TransactionalExecutor executor = this.transactionalExecutorFactory.createExecutor(readOnly, false);
        return (T)executor.execute(arg_0 -> QueryDslDbConnectionManager.execute$lambda$2(this, callback, arg_0));
    }

    public static /* synthetic */ Object execute$default(QueryDslDbConnectionManager queryDslDbConnectionManager, boolean bl, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return queryDslDbConnectionManager.execute(bl, function1);
    }

    private final void setCasingRulesBasedOnDbms(Configuration configuration) {
        DatabaseType databaseType = this.provider.getDatabaseType();
        if (databaseType == DatabaseType.POSTGRESQL) {
            PreConfiguredNameMapping lowerCaseMapping = new PreConfiguredNameMapping();
            lowerCaseMapping.registerTableOverride("SPACES", "spaces");
            lowerCaseMapping.registerColumnOverride("SPACES", "SPACEKEY", "spacekey");
            lowerCaseMapping.registerColumnOverride("SPACES", "SPACENAME", "spacename");
            lowerCaseMapping.registerColumnOverride("SPACES", "SPACETYPE", "spacetype");
            lowerCaseMapping.registerColumnOverride("SPACES", "SPACESTATUS", "spacestatus");
            lowerCaseMapping.registerTableOverride("CONTENT", "content");
            lowerCaseMapping.registerColumnOverride("CONTENT", "CONTENTID", "contentid");
            lowerCaseMapping.registerColumnOverride("CONTENT", "TITLE", "title");
            lowerCaseMapping.registerColumnOverride("CONTENT", "CONTENTTYPE", "contenttype");
            lowerCaseMapping.registerColumnOverride("CONTENT", "CONTENT_STATUS", "content_status");
            lowerCaseMapping.registerColumnOverride("CONTENT", "PREVVER", "prevver");
            lowerCaseMapping.registerColumnOverride("CONTENT", "SPACEID", "spaceid");
            lowerCaseMapping.registerColumnOverride("CONTENT", "CREATIONDATE", "creationdate");
            lowerCaseMapping.registerColumnOverride("CONTENT", "LASTMODDATE", "lastmoddate");
            configuration.setDynamicNameMapping((NameMapping)lowerCaseMapping);
        }
    }

    private final SQLTemplates getDialect(DatabaseMetaData metaData) {
        DatabaseType databaseType = this.provider.getDatabaseType();
        this.logger.debug("Database Type: " + databaseType);
        DatabaseType databaseType2 = databaseType;
        SQLTemplates.Builder builder2 = switch (databaseType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[databaseType2.ordinal()]) {
            case 1 -> ExtendedOracleTemplate.Companion.builder();
            case 2 -> ExtendedMysqlTemplate.Companion.builder();
            case 3 -> ExtendedPostgresTemplate.Companion.builder();
            case 4 -> ExtendedSqlServerTemplate.Companion.builder();
            case 5 -> ExtendedH2Template.Companion.builder();
            case 6 -> HSQLDBTemplates.builder();
            case 7 -> DerbyTemplates.builder();
            case 8 -> DerbyTemplates.builder();
            case 9 -> DB2Templates.builder();
            case 10 -> throw new UnsupportedOperationException("Unsupported database type '" + databaseType + "'");
            case 11 -> {
                this.logger.warn("Unknown database detected. Falling back to use the H2Templates templates for QueryDSL.");
                yield ExtendedH2Template.Companion.builder();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        builder2.newLineToSingleSpace().quote();
        if (this.provider.getSchema() != null) {
            builder2.printSchema();
        }
        SQLTemplates sQLTemplates = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)sQLTemplates, (String)"build(...)");
        return sQLTemplates;
    }

    private static final Connection execute$lambda$2$lambda$0(Connection $it) {
        return $it;
    }

    /*
     * WARNING - void declaration
     */
    private static final Object execute$lambda$2(QueryDslDbConnectionManager this$0, Function1 $callback, Connection it) {
        void klass$iv;
        DatabaseMetaData databaseMetaData = it.getMetaData();
        Intrinsics.checkNotNullExpressionValue((Object)databaseMetaData, (String)"getMetaData(...)");
        Configuration configuration = new Configuration(this$0.getDialect(databaseMetaData));
        this$0.setCasingRulesBasedOnDbms(configuration);
        SQLQueryFactory queryFactory = new SQLQueryFactory(configuration, () -> QueryDslDbConnectionManager.execute$lambda$2$lambda$0(it));
        KClass kClass = Reflection.getOrCreateKotlinClass(this$0.getClass());
        String name$iv = "callback";
        boolean $i$f$atlassianProfilingTimer = false;
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.push((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        boolean bl = false;
        Object result$iv = $callback.invoke((Object)queryFactory);
        if (UtilTimerStack.isActive()) {
            UtilTimerStack.pop((String)(klass$iv.getQualifiedName() + "_" + name$iv));
        }
        return result$iv;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.ORACLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MYSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.POSTGRESQL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.MS_SQL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.H2.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.HSQL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.DERBY_EMBEDDED.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.DERBY_NETWORK.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.DB2.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.NUODB.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.UNKNOWN.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

