/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.store.server.settings;

import com.addonengine.addons.analytics.store.server.querydsl.QueryDslDbConnectionManager;
import com.addonengine.addons.analytics.store.server.querydsl.Tables;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u0004\u0018\u0001H\t\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0086\b\u00a2\u0006\u0002\u0010\fJ-\u0010\b\u001a\u0004\u0018\u0001H\t\"\b\b\u0000\u0010\t*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u000e\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0010\u001a\u00020\u0011\"\u0004\b\u0000\u0010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u0002H\t\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/addonengine/addons/analytics/store/server/settings/Settings;", "", "db", "Lcom/addonengine/addons/analytics/store/server/querydsl/QueryDslDbConnectionManager;", "<init>", "(Lcom/addonengine/addons/analytics/store/server/querydsl/QueryDslDbConnectionManager;)V", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "get", "T", "key", "", "(Ljava/lang/String;)Ljava/lang/Object;", "klass", "Lkotlin/reflect/KClass;", "(Ljava/lang/String;Lkotlin/reflect/KClass;)Ljava/lang/Object;", "set", "", "value", "(Ljava/lang/String;Ljava/lang/Object;)V", "delete", "", "getValueAsString", "analytics"})
public final class Settings {
    @NotNull
    private final QueryDslDbConnectionManager db;
    @NotNull
    private final ObjectMapper mapper;

    @Inject
    public Settings(@NotNull QueryDslDbConnectionManager db) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.db = db;
        this.mapper = new ObjectMapper();
    }

    public final /* synthetic */ <T> T get(String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$get = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return this.get(key, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @Nullable
    public final <T> T get(@NotNull String key, @NotNull KClass<T> klass) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        String value = this.getValueAsString(key);
        return (T)(value == null ? null : this.mapper.readValue(value, JvmClassMappingKt.getJavaClass(klass)));
    }

    public final <T> void set(@NotNull String key, T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String valueString = this.mapper.writeValueAsString(value);
        this.db.execute(false, arg_0 -> Settings.set$lambda$0(this, key, valueString, arg_0));
    }

    public final boolean delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        long rowCount = ((Number)this.db.execute(false, arg_0 -> Settings.delete$lambda$1(key, arg_0))).longValue();
        return rowCount > 0L;
    }

    private final String getValueAsString(String key) {
        return (String)QueryDslDbConnectionManager.execute$default(this.db, false, arg_0 -> Settings.getValueAsString$lambda$2(key, arg_0), 1, null);
    }

    private static final long set$lambda$0(Settings this$0, String $key, String $valueString, SQLQueryFactory sqlQueryFactory) {
        Intrinsics.checkNotNullParameter((Object)sqlQueryFactory, (String)"sqlQueryFactory");
        boolean exists = this$0.getValueAsString($key) != null;
        long now = Instant.now().toEpochMilli();
        return exists ? ((SQLUpdateClause)((SQLUpdateClause)((SQLUpdateClause)sqlQueryFactory.update((RelationalPath)Tables.INSTANCE.getSettings()).set((Path)Tables.INSTANCE.getSettings().getValue(), (Object)$valueString)).set((Path)Tables.INSTANCE.getSettings().getUpdatedAt(), (Object)now)).where((Predicate)Tables.INSTANCE.getSettings().getKey().eq((Object)$key))).execute() : ((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)((SQLInsertClause)sqlQueryFactory.insert((RelationalPath)Tables.INSTANCE.getSettings()).set((Path)Tables.INSTANCE.getSettings().getKey(), (Object)$key)).set((Path)Tables.INSTANCE.getSettings().getValue(), (Object)$valueString)).set((Path)Tables.INSTANCE.getSettings().getCreatedAt(), (Object)now)).set((Path)Tables.INSTANCE.getSettings().getUpdatedAt(), (Object)now)).execute();
    }

    private static final long delete$lambda$1(String $key, SQLQueryFactory sqlQueryFactory) {
        Intrinsics.checkNotNullParameter((Object)sqlQueryFactory, (String)"sqlQueryFactory");
        return ((SQLDeleteClause)sqlQueryFactory.delete((RelationalPath)Tables.INSTANCE.getSettings()).where((Predicate)Tables.INSTANCE.getSettings().getKey().eq((Object)$key))).execute();
    }

    private static final String getValueAsString$lambda$2(String $key, SQLQueryFactory sqlQueryFactory) {
        Intrinsics.checkNotNullParameter((Object)sqlQueryFactory, (String)"sqlQueryFactory");
        return (String)((SQLQuery)((SQLQuery)sqlQueryFactory.select((Expression)Tables.INSTANCE.getSettings().getValue()).from((Expression)Tables.INSTANCE.getSettings())).where((Predicate)Tables.INSTANCE.getSettings().getKey().eq((Object)$key))).fetchOne();
    }
}

