/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.web.actions;

import com.addonengine.addons.analytics.service.confluence.UrlBuilder;
import com.addonengine.addons.analytics.web.actions.AnalyticsAction;
import com.addonengine.addons.analytics.web.context.ConnectHostContextBuilder;
import com.addonengine.addons.analytics.web.context.ConnectHostParams;
import com.addonengine.addons.analytics.web.context.LicenseContext;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c0\u001bJ\b\u0010\"\u001a\u00020\tH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001d\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c0\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0019\u00a8\u0006#"}, d2={"Lcom/addonengine/addons/analytics/web/actions/AbstractAdminToolsAction;", "Lcom/atlassian/confluence/core/ConfluenceActionSupport;", "connectHostContextBuilder", "Lcom/addonengine/addons/analytics/web/context/ConnectHostContextBuilder;", "licenseContext", "Lcom/addonengine/addons/analytics/web/context/LicenseContext;", "connectHostParams", "Lcom/addonengine/addons/analytics/web/context/ConnectHostParams;", "titleKey", "", "webItemKey", "urlBuilder", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "<init>", "(Lcom/addonengine/addons/analytics/web/context/ConnectHostContextBuilder;Lcom/addonengine/addons/analytics/web/context/LicenseContext;Lcom/addonengine/addons/analytics/web/context/ConnectHostParams;Ljava/lang/String;Ljava/lang/String;Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/sal/api/timezone/TimeZoneManager;)V", "getLicenseContext", "()Lcom/addonengine/addons/analytics/web/context/LicenseContext;", "addonKey", "addonPath", "title", "getTitle", "()Ljava/lang/String;", "connectHostContext", "", "", "getConnectHostContext", "()Ljava/util/Map;", "selectedWebItem", "getSelectedWebItem", "getAppContext", "execute", "analytics"})
public abstract class AbstractAdminToolsAction
extends ConfluenceActionSupport {
    @NotNull
    private final ConnectHostContextBuilder connectHostContextBuilder;
    @NotNull
    private final LicenseContext licenseContext;
    @NotNull
    private final ConnectHostParams connectHostParams;
    @NotNull
    private final String titleKey;
    @NotNull
    private final String webItemKey;
    @NotNull
    private final UrlBuilder urlBuilder;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private final String addonKey;
    @NotNull
    private final String addonPath;

    public AbstractAdminToolsAction(@NotNull ConnectHostContextBuilder connectHostContextBuilder, @NotNull LicenseContext licenseContext, @NotNull ConnectHostParams connectHostParams, @NotNull String titleKey, @NotNull String webItemKey, @NotNull UrlBuilder urlBuilder, @NotNull UserManager userManager, @NotNull TimeZoneManager timeZoneManager) {
        Intrinsics.checkNotNullParameter((Object)connectHostContextBuilder, (String)"connectHostContextBuilder");
        Intrinsics.checkNotNullParameter((Object)licenseContext, (String)"licenseContext");
        Intrinsics.checkNotNullParameter((Object)connectHostParams, (String)"connectHostParams");
        Intrinsics.checkNotNullParameter((Object)titleKey, (String)"titleKey");
        Intrinsics.checkNotNullParameter((Object)webItemKey, (String)"webItemKey");
        Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)timeZoneManager, (String)"timeZoneManager");
        this.connectHostContextBuilder = connectHostContextBuilder;
        this.licenseContext = licenseContext;
        this.connectHostParams = connectHostParams;
        this.titleKey = titleKey;
        this.webItemKey = webItemKey;
        this.urlBuilder = urlBuilder;
        this.userManager = userManager;
        this.timeZoneManager = timeZoneManager;
        this.addonKey = "com.addonengine.analytics";
        this.addonPath = "confanalytics";
    }

    @NotNull
    public final LicenseContext getLicenseContext() {
        return this.licenseContext;
    }

    @NotNull
    public final String getTitle() {
        String string = this.getText(this.titleKey);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final Map<String, Object> getConnectHostContext() {
        HttpServletRequest httpServletRequest = this.getActiveRequest();
        Intrinsics.checkNotNullExpressionValue((Object)httpServletRequest, (String)"getActiveRequest(...)");
        return this.connectHostContextBuilder.buildContext(httpServletRequest, this.connectHostParams);
    }

    @NotNull
    public final String getSelectedWebItem() {
        return this.webItemKey;
    }

    @NotNull
    public final Map<String, Object> getAppContext() {
        String string = this.urlBuilder.buildHostActionUrl("analytics").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String analyticsActionUrl = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spaceAnalyticsUrl", (Object)(analyticsActionUrl + "#/analytics/space/{space.key}/{view}")), TuplesKt.to((Object)"userIsAdmin", (Object)this.userManager.isAdmin(this.getAuthenticatedUser().getKey()))};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        I18NBean i18NBean = this.getI18n();
        Intrinsics.checkNotNullExpressionValue((Object)i18NBean, (String)"getI18n(...)");
        return MapsKt.plus((Map)map, AnalyticsAction.Companion.getBaseContext(this.urlBuilder, i18NBean, this.timeZoneManager));
    }

    @PermittedMethods(value={HttpMethod.GET})
    @NotNull
    public String execute() {
        if (this.isAnonymousUser()) {
            return "accessdenied";
        }
        if (this.licenseContext.isValid()) {
            String string = super.execute();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"execute(...)");
            return string;
        }
        return "license";
    }
}

