/*
 * Decompiled with CFR 0.152.
 */
package com.addonengine.addons.analytics.web.actions;

import com.addonengine.addons.analytics.service.confluence.UrlBuilder;
import com.addonengine.addons.analytics.util.UtilsKt;
import com.addonengine.addons.analytics.web.context.LicenseContext;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.VersionSpecificDocumentationBean;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0001\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00140\u0013J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0019"}, d2={"Lcom/addonengine/addons/analytics/web/actions/AnalyticsAction;", "Lcom/atlassian/confluence/spaces/actions/AbstractSpaceAction;", "urlBuilder", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "licenseContext", "Lcom/addonengine/addons/analytics/web/context/LicenseContext;", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "<init>", "(Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;Lcom/addonengine/addons/analytics/web/context/LicenseContext;Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/sal/api/timezone/TimeZoneManager;)V", "addonKey", "", "addonPath", "title", "getTitle", "()Ljava/lang/String;", "getAppContext", "", "", "getIsDevelopment", "", "execute", "Companion", "analytics"})
public final class AnalyticsAction
extends AbstractSpaceAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UrlBuilder urlBuilder;
    @NotNull
    private final LicenseContext licenseContext;
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final TimeZoneManager timeZoneManager;
    @NotNull
    private final String addonKey;
    @NotNull
    private final String addonPath;

    @Inject
    public AnalyticsAction(@NotNull UrlBuilder urlBuilder, @NotNull LicenseContext licenseContext, @ComponentImport @NotNull UserManager userManager, @ComponentImport @NotNull TimeZoneManager timeZoneManager) {
        Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
        Intrinsics.checkNotNullParameter((Object)licenseContext, (String)"licenseContext");
        Intrinsics.checkNotNullParameter((Object)userManager, (String)"userManager");
        Intrinsics.checkNotNullParameter((Object)timeZoneManager, (String)"timeZoneManager");
        this.urlBuilder = urlBuilder;
        this.licenseContext = licenseContext;
        this.userManager = userManager;
        this.timeZoneManager = timeZoneManager;
        this.addonKey = "com.addonengine.analytics";
        this.addonPath = "confanalytics";
    }

    @NotNull
    public final String getTitle() {
        String string = this.getText("com.addonengine.addons.analytics.page.title");
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final Map<String, Object> getAppContext() {
        String string = this.urlBuilder.buildHostActionUrl("analytics").toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String analyticsActionUrl = string;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"spaceAnalyticsUrl", (Object)(analyticsActionUrl + "?key={space.key}#/analytics/space/{space.key}")), TuplesKt.to((Object)"userIsAdmin", (Object)this.userManager.isAdmin(this.getAuthenticatedUser().getKey()))};
        Map map = MapsKt.mapOf((Pair[])pairArray);
        I18NBean i18NBean = this.getI18n();
        Intrinsics.checkNotNullExpressionValue((Object)i18NBean, (String)"getI18n(...)");
        return MapsKt.plus((Map)map, Companion.getBaseContext(this.urlBuilder, i18NBean, this.timeZoneManager));
    }

    public final boolean getIsDevelopment() {
        return UtilsKt.isAddonDevMode();
    }

    @PermittedMethods(value={HttpMethod.GET})
    @NotNull
    public String execute() {
        if (this.isAnonymousUser()) {
            return "accessdenied";
        }
        if (this.licenseContext.isValid()) {
            String string = this.getActiveRequest().getParameter("result");
            if (string == null) {
                String string2 = super.execute();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"execute(...)");
            }
            return string;
        }
        return "license";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/addonengine/addons/analytics/web/actions/AnalyticsAction$Companion;", "", "<init>", "()V", "getBaseContext", "", "", "urlBuilder", "Lcom/addonengine/addons/analytics/service/confluence/UrlBuilder;", "i18NBean", "Lcom/atlassian/confluence/util/i18n/I18NBean;", "timeZoneManager", "Lcom/atlassian/sal/api/timezone/TimeZoneManager;", "analytics"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, Object> getBaseContext(@NotNull UrlBuilder urlBuilder, @NotNull I18NBean i18NBean, @NotNull TimeZoneManager timeZoneManager) {
            Intrinsics.checkNotNullParameter((Object)urlBuilder, (String)"urlBuilder");
            Intrinsics.checkNotNullParameter((Object)i18NBean, (String)"i18NBean");
            Intrinsics.checkNotNullParameter((Object)timeZoneManager, (String)"timeZoneManager");
            String baseUrl = urlBuilder.getBaseUrl();
            String string = urlBuilder.buildHostActionUrl("analytics").toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String analyticsActionUrl = string;
            DocumentationBean docBean = (DocumentationBean)new VersionSpecificDocumentationBean(BuildInformation.INSTANCE.getVersionNumber(), i18NBean);
            String helpNavLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.nav.link.url");
            String googleAnalyticsHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.google.analytics.help.link.url");
            String increasedPrivacyModeHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.increased.privacy.mode.link.url");
            String permissionHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.permission.link.url");
            String dataRetentionHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.data.retention.link.url");
            String eventLimitHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.event.limit.link.url");
            String rateLimitHelpLinkUrl = docBean.getLink("com.addonengine.addons.analytics.help.rate.limit.link.url");
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"localBaseUrl", (Object)(baseUrl + "/rest/confanalytics/1.0")), TuplesKt.to((Object)"hostBaseUrl", (Object)baseUrl), TuplesKt.to((Object)"instanceAnalyticsUrl", (Object)(analyticsActionUrl + "#/analytics/instance/{view}")), TuplesKt.to((Object)"contentAnalyticsUrl", (Object)(analyticsActionUrl + "#/analytics/content/page/{content.id}")), TuplesKt.to((Object)"spacePermissionsUrl", (Object)(urlBuilder.buildHostActionUrl("spacepermissions") + "?key={space.key}#/")), TuplesKt.to((Object)"addonKey", (Object)"com.addonengine.analytics"), TuplesKt.to((Object)"pageKey", (Object)"analytics-page"), TuplesKt.to((Object)"anonymousUserProfilePictureUrl", (Object)urlBuilder.getAnonymousUserProfilePictureUrl()), TuplesKt.to((Object)"tzId", (Object)timeZoneManager.getUserTimeZone().getID()), TuplesKt.to((Object)"googleAnalyticsHelpLinkUrl", (Object)googleAnalyticsHelpLinkUrl), TuplesKt.to((Object)"helpNavLinkUrl", (Object)helpNavLinkUrl), TuplesKt.to((Object)"increasedPrivacyModeHelpLinkUrl", (Object)increasedPrivacyModeHelpLinkUrl), TuplesKt.to((Object)"permissionHelpLinkUrl", (Object)permissionHelpLinkUrl), TuplesKt.to((Object)"eventLimitHelpLinkUrl", (Object)eventLimitHelpLinkUrl), TuplesKt.to((Object)"dataRetentionHelpLinkUrl", (Object)dataRetentionHelpLinkUrl), TuplesKt.to((Object)"rateLimitHelpLinkUrl", (Object)rateLimitHelpLinkUrl)};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

